/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.filter;

import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Cast;
import oracle.bpm.util.CatalogLoaderMgr;

public class SerializationFilterSession
implements HttpSession {
    private AttributeMarshaller attributeMarshaller;
    private final boolean debug;
    private boolean dirty;
    private final HttpSession httpSession;
    private final String pattern;
    private static final String ATTRIBUTE_MARSHALLER_KEY = "fuego.portal.filter.SerializationFilterSession.attributes";

    public SerializationFilterSession(HttpSession httpSession) {
        this(httpSession, false);
    }

    public SerializationFilterSession(HttpSession httpSession, boolean debug) {
        this(httpSession, debug, null);
    }

    public SerializationFilterSession(HttpSession httpSession, boolean debug, String pattern) {
        assert (!(httpSession instanceof SerializationFilterSession)) : "filtering myself";
        this.httpSession = httpSession;
        this.debug = debug;
        this.pattern = pattern;
    }

    public long getCreationTime() {
        return this.httpSession.getCreationTime();
    }

    public String getId() {
        return this.httpSession.getId();
    }

    public long getLastAccessedTime() {
        return this.httpSession.getLastAccessedTime();
    }

    public ServletContext getServletContext() {
        return this.httpSession.getServletContext();
    }

    public void setMaxInactiveInterval(int interval) {
        this.httpSession.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval() {
        return this.httpSession.getMaxInactiveInterval();
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        return this.httpSession.getSessionContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        Object value;
        HttpSession httpSession = this.httpSession;
        synchronized (httpSession) {
            Map<String, Object> attributes = this.getAttributes();
            value = attributes.get(name);
        }
        if (value == null) {
            value = this.httpSession.getAttribute(name);
        }
        return value;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return new Enumeration(){
            private int index = 0;
            private String[] names = SerializationFilterSession.this.getValueNames();

            @Override
            public boolean hasMoreElements() {
                return this.index < this.names.length;
            }

            public Object nextElement() {
                return this.names[this.index++];
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValueNames() {
        HashSet<String> names = new HashSet<String>();
        HttpSession httpSession = this.httpSession;
        synchronized (httpSession) {
            names.addAll(this.getAttributes().keySet());
            Enumeration e = this.httpSession.getAttributeNames();
            while (e.hasMoreElements()) {
                names.add((String)e.nextElement());
            }
        }
        return names.toArray(new String[names.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        boolean localAttribute;
        HttpSession httpSession = this.httpSession;
        synchronized (httpSession) {
            Map<String, Object> attributes = this.getAttributes();
            boolean bl = localAttribute = this.httpSession.getAttribute(name) == null;
            if (localAttribute) {
                attributes.put(name, value);
            } else {
                this.httpSession.setAttribute(name, value);
            }
        }
        if (localAttribute) {
            this.dispatchBindingEvent(name, value, true);
        }
        if (this.debug && (this.pattern == null || name.indexOf(this.pattern) != -1)) {
            System.out.println("SerializationFilterSession.setAttribute(" + name + ", " + value + ")");
            try {
                Any.deepCopy((Object)this.attributeMarshaller);
            }
            catch (Throwable t) {
                PrintStream printStream = System.err;
                synchronized (printStream) {
                    System.err.println("!!! Trying to set a non serializable value => [Attr:" + name + "] [Value: " + value != null ? value.getClass().getName() : null + "]");
                    t.printStackTrace(System.err);
                }
            }
        }
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object value;
        HttpSession httpSession = this.httpSession;
        synchronized (httpSession) {
            value = this.getAttributes().remove(name);
        }
        this.dispatchBindingEvent(name, value, false);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.httpSession.invalidate();
    }

    public boolean isNew() {
        return this.httpSession.isNew();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestProcessed() {
        HttpSession httpSession = this.httpSession;
        synchronized (httpSession) {
            if (this.attributeMarshaller != null && this.dirty) {
                this.httpSession.setAttribute(ATTRIBUTE_MARSHALLER_KEY, (Object)this.attributeMarshaller);
                this.dirty = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getAttributes() {
        Map<String, Object> attributesMap;
        HttpSession httpSession = this.httpSession;
        synchronized (httpSession) {
            if (this.attributeMarshaller == null) {
                this.attributeMarshaller = (AttributeMarshaller)this.httpSession.getAttribute(ATTRIBUTE_MARSHALLER_KEY);
                if (this.attributeMarshaller == null) {
                    this.attributeMarshaller = new AttributeMarshaller(new HashMap<String, Object>());
                }
            }
            this.dirty = true;
            attributesMap = this.attributeMarshaller.getAttributes();
        }
        return attributesMap;
    }

    private void dispatchBindingEvent(String name, Object value, boolean bound) {
        HttpSessionBindingListener listener = null;
        if (value instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)value;
        }
        if (listener != null) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name);
            if (bound) {
                listener.valueBound(event);
            } else {
                listener.valueUnbound(event);
            }
        }
    }

    private static class AttributeMarshaller
    implements Serializable {
        private transient Map<String, Object> attributes;
        private static final long serialVersionUID = -2158352935354482830L;

        public AttributeMarshaller(Map<String, Object> attributes) {
            this.attributes = attributes;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public String toString() {
            return this.attributes.toString();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            BufferedOutputStream bos = new BufferedOutputStream(out){

                @Override
                public void close() throws IOException {
                    this.flush();
                }
            };
            ObjectOutputStream cos = new ObjectOutputStream(bos){

                protected void annotateClass(Class cl) throws IOException {
                    CatalogLoaderMgr.annotateClass((ObjectOutputStream)this, (Class)cl);
                }
            };
            cos.writeObject(this.attributes);
            cos.close();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            FilterInputStream fis = new FilterInputStream(in){

                @Override
                public void close() {
                }
            };
            ObjectInputStream cis = new ObjectInputStream(fis){

                protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    Class<?> aClass = CatalogLoaderMgr.resolveClass((ObjectInputStream)this, (ObjectStreamClass)desc);
                    if (aClass == null) {
                        aClass = super.resolveClass(desc);
                    }
                    return aClass;
                }
            };
            this.attributes = (Map)Cast.force((Object)cis.readObject());
            cis.close();
        }
    }
}

