/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.bpm.log.Log;

public abstract class BaseFilter
implements Filter {
    private boolean isEnabled = true;

    public abstract void doFilter(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws IOException, ServletException;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.logDebug("Starting filter.");
        if (filterConfig != null) {
            String value = filterConfig.getInitParameter("enabled");
            if (value != null) {
                this.isEnabled = Boolean.valueOf(value);
            }
            this.logDebug("Filter enabled property = " + this.isEnabled);
        }
    }

    public void destroy() {
        this.logDebug("Destroying filter.");
    }

    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isEnabled) {
            this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    protected void logDebug(String msg) {
        if (Log.isDebugging()) {
            Log.logDebug((String)(this.getClass().getName() + ": " + msg));
        }
    }
}

