/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.Activity;
import fuego.papi.InstanceInfo;
import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessServiceSession;
import fuego.papi.Task;
import fuego.papi.exception.TaskOperationException;
import java.util.Locale;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiInstanceOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiTaskOperationException
extends WapiInstanceOperationException {
    static final long serialVersionUID = -644308781391255765L;
    static final long serialCheck = -6299266885055776387L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiTaskOperationException(TaskOperationException exception, ErrorContext context) {
        this.init((OperationException)exception, context);
        ProcessServiceSession serviceSession = context.getProcessServiceSession();
        String instanceDesc = exception.getInstanceId();
        String taskLabel = String.valueOf(exception.getTaskNumber());
        String activityLabel = exception.getActivityId();
        if (exception.getTaskNumber() != -1 && exception.getInstanceId() != null && exception.getActivityId() != null && exception.getProcessId() != null) {
            try {
                InstanceInfo instanceInfo = serviceSession.processGetInstance(exception.getInstanceId());
                Task task = instanceInfo.getTask(exception.getTaskNumber());
                Locale locale = serviceSession.participantLocale();
                taskLabel = task.getLabel(locale);
                instanceDesc = instanceInfo.getDescription();
                Process process = serviceSession.processGet(exception.getProcessId());
                Activity activity = process.getActivity(exception.getActivityId());
                activityLabel = activity.getLabel(locale);
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_3401(taskLabel, instanceDesc, activityLabel));
            }
        } else {
            this.setKey(WebMsg.WAPI_3400);
        }
    }

    protected WapiTaskOperationException() {
    }
}

