/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.Activity;
import fuego.papi.InstanceInfo;
import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessServiceSession;
import fuego.papi.Task;
import fuego.papi.exception.TaskNotUnselectedException;
import java.util.Locale;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiTaskOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiTaskNotUnselectedException
extends WapiTaskOperationException {
    static final long serialVersionUID = 3107170278817947867L;
    static final long serialCheck = -350931540892890901L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiTaskNotUnselectedException(TaskNotUnselectedException exception, ErrorContext context) {
        this.init((OperationException)((Object)exception), context);
        ProcessServiceSession serviceSession = context.getProcessServiceSession();
        String taskLabel = String.valueOf(exception.getTaskNumber());
        String activityLabel = exception.getActivityId();
        if (exception.getTaskNumber() != -1 && exception.getInstanceId() != null && exception.getActivityId() != null && exception.getProcessId() != null) {
            try {
                InstanceInfo instanceInfo = serviceSession.processGetInstance(exception.getInstanceId());
                Task task = instanceInfo.getTask(exception.getTaskNumber());
                Locale locale = serviceSession.participantLocale();
                taskLabel = task.getLabel(locale);
                Process process = serviceSession.processGet(exception.getProcessId());
                Activity activity = process.getActivity(exception.getActivityId());
                activityLabel = activity.getLabel(locale);
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_3421(taskLabel, activityLabel));
            }
        } else {
            this.setKey(WebMsg.WAPI_3420);
        }
    }

    protected WapiTaskNotUnselectedException() {
    }
}

