/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.Activity;
import fuego.papi.InstanceInfo;
import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessServiceSession;
import fuego.papi.Task;
import fuego.papi.exception.TaskNotFoundException;
import java.util.Locale;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiInstanceOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiTaskNotFoundException
extends WapiInstanceOperationException {
    static final long serialVersionUID = -4237134557183443326L;
    static final long serialCheck = 3409320376844184982L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiTaskNotFoundException(TaskNotFoundException exception, ErrorContext context) {
        this.init((OperationException)exception, context);
        ProcessServiceSession serviceSession = context.getProcessServiceSession();
        String instanceDesc = exception.getInstanceId();
        String taskLabel = String.valueOf(exception.getTaskNumber());
        String activityLabel = exception.getActivityId();
        if (exception.getProcessId() != null && exception.getInstanceId() != null && exception.getActivityId() != null && exception.getTaskNumber() != -1) {
            try {
                InstanceInfo instanceInfo = serviceSession.processGetInstance(exception.getInstanceId());
                instanceDesc = instanceInfo.getDescription();
                Process process = serviceSession.processGet(exception.getProcessId());
                Activity activity = process.getActivity(exception.getActivityId());
                Locale locale = serviceSession.participantLocale();
                activityLabel = activity.getLabel(locale);
                InstanceInfo info = serviceSession.processGetInstance(exception.getInstanceId());
                Task task = info.getTask(exception.getTaskNumber());
                taskLabel = task.getLabel(locale);
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_1411(taskLabel, instanceDesc, activityLabel));
            }
        } else {
            this.setKey(WebMsg.WAPI_1410);
        }
    }
}

