/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.Activity;
import fuego.papi.InstanceInfo;
import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessServiceSession;
import fuego.papi.Task;
import fuego.papi.exception.TaskFailedException;
import java.util.Locale;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiTaskOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiTaskFailedException
extends WapiTaskOperationException {
    static final long serialVersionUID = -7461492703121102808L;
    static final long serialCheck = 2900620101052085565L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiTaskFailedException(TaskFailedException exception, ErrorContext context) {
        this.init((OperationException)((Object)exception), context);
        ProcessServiceSession serviceSession = context.getProcessServiceSession();
        String instanceDesc = exception.getInstanceId();
        String taskLabel = String.valueOf(exception.getTaskNumber());
        String activityLabel = exception.getActivityId();
        if (exception.getTaskNumber() != -1 && exception.getInstanceId() != null && exception.getActivityId() != null && exception.getProcessId() != null) {
            try {
                InstanceInfo instanceInfo = serviceSession.processGetInstance(exception.getInstanceId());
                Task task = instanceInfo.getTask(exception.getTaskNumber());
                Locale locale = serviceSession.participantLocale();
                taskLabel = task.getLabel(locale);
                Process process = serviceSession.processGet(exception.getProcessId());
                Activity activity = process.getActivity(exception.getActivityId());
                activityLabel = activity.getLabel(locale);
                instanceDesc = instanceInfo.getDescription();
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_3457(taskLabel, activityLabel, instanceDesc));
            }
        } else {
            this.setKey(WebMsg.WAPI_3456);
        }
    }

    protected WapiTaskFailedException() {
    }
}

