/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.Activity;
import fuego.papi.InstanceInfo;
import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessServiceSession;
import fuego.papi.Task;
import fuego.papi.exception.TaskCompletedException;
import java.util.Locale;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiTaskOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiTaskCompletedException
extends WapiTaskOperationException {
    static final long serialVersionUID = -5655358313095283518L;
    static final long serialCheck = -220706511114554576L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiTaskCompletedException(TaskCompletedException exception, ErrorContext context) {
        this.init((OperationException)((Object)exception), context);
        ProcessServiceSession serviceSession = context.getProcessServiceSession();
        String instanceDesc = exception.getInstanceId();
        String taskLabel = String.valueOf(exception.getTaskNumber());
        String activityLabel = exception.getActivityId();
        String participantName = exception.getParticipantId();
        if (exception.getProcessId() != null && exception.getInstanceId() != null && exception.getActivityId() != null && exception.getTaskNumber() != -1 && exception.getParticipantId() != null) {
            try {
                InstanceInfo instanceInfo = serviceSession.processGetInstance(exception.getInstanceId());
                instanceDesc = instanceInfo.getDescription();
                Process process = serviceSession.processGet(exception.getProcessId());
                Activity activity = process.getActivity(exception.getActivityId());
                Locale locale = serviceSession.participantLocale();
                activityLabel = activity.getLabel(locale);
                Task task = instanceInfo.getTask(exception.getTaskNumber());
                taskLabel = task.getLabel(locale);
                participantName = serviceSession.participantFind(exception.getParticipantId()).getName();
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_3432(taskLabel, instanceDesc, activityLabel, participantName));
            }
        } else if (exception.getProcessId() != null && exception.getInstanceId() != null && exception.getActivityId() != null && exception.getTaskNumber() != -1) {
            try {
                InstanceInfo instanceInfo = serviceSession.processGetInstance(exception.getInstanceId());
                instanceDesc = instanceInfo.getDescription();
                Process process = serviceSession.processGet(exception.getProcessId());
                Activity activity = process.getActivity(exception.getActivityId());
                Locale locale = serviceSession.participantLocale();
                activityLabel = activity.getLabel(locale);
                Task task = instanceInfo.getTask(exception.getTaskNumber());
                taskLabel = task.getLabel(locale);
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_3431(taskLabel, instanceDesc, activityLabel));
            }
        } else {
            this.setKey(WebMsg.WAPI_3430);
        }
    }
}

