/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.Activity;
import fuego.papi.InstanceInfo;
import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessServiceSession;
import fuego.papi.Task;
import fuego.papi.exception.TaskAlreadySelectedException;
import java.util.Locale;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiTaskOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiTaskAlreadySelectedException
extends WapiTaskOperationException {
    static final long serialVersionUID = 4348604694514740305L;
    static final long serialCheck = -9104424162597176372L;

    public WapiTaskAlreadySelectedException() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiTaskAlreadySelectedException(TaskAlreadySelectedException exception, ErrorContext context) {
        this.init((OperationException)((Object)exception), context);
        ProcessServiceSession serviceSession = context.getProcessServiceSession();
        String instanceDesc = exception.getInstanceId();
        String taskLabel = String.valueOf(exception.getTaskNumber());
        String activityLabel = exception.getActivityId();
        String participantName = exception.getParticipantId();
        if (exception.getProcessId() != null && exception.getTaskNumber() != -1 && exception.getInstanceId() != null && exception.getParticipantId() != null && exception.getActivityId() != null) {
            try {
                InstanceInfo instanceInfo = serviceSession.processGetInstance(exception.getInstanceId());
                Task task = instanceInfo.getTask(exception.getTaskNumber());
                Locale locale = serviceSession.participantLocale();
                taskLabel = task.getLabel(locale);
                Process process = serviceSession.processGet(exception.getProcessId());
                Activity activity = process.getActivity(exception.getActivityId());
                activityLabel = activity.getLabel(locale);
                instanceDesc = instanceInfo.getDescription();
                participantName = serviceSession.participantFind(exception.getParticipantId()).getName();
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_3441(taskLabel, activityLabel, instanceDesc, participantName));
            }
        } else {
            this.setKey(WebMsg.WAPI_3440);
        }
    }
}

