/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.OperationException;
import fuego.papi.ProcessServiceSession;
import fuego.papi.exception.ReleaseAttachmentException;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiAttachmentOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiReleaseAttachmentException
extends WapiAttachmentOperationException {
    static final long serialVersionUID = -770058683099313847L;
    static final long serialCheck = 1058520340597235283L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiReleaseAttachmentException(ReleaseAttachmentException exception, ErrorContext context) {
        this.init((OperationException)exception, context);
        ProcessServiceSession serviceSession = context.getProcessServiceSession();
        String attachmentDesc = exception.getAttachementId();
        String participantName = exception.getParticipantId();
        if (exception.getAttachementId() == null) {
            this.setKey(WebMsg.WAPI_7110);
        } else {
            try {
                attachmentDesc = serviceSession.attachmentGet(exception.getAttachementId()).getDescription();
                participantName = serviceSession.participantFind(exception.getParticipantId()).getName();
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_7111(attachmentDesc, participantName));
            }
        }
    }
}

