/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessOperationException;
import fuego.papi.ProcessServiceSession;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiProcessOperationException
extends WapiOperationException {
    static final long serialVersionUID = 2555464724093626165L;
    static final long serialCheck = -8307116470875536947L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiProcessOperationException(ProcessOperationException exception, ErrorContext context) {
        this.init((OperationException)exception, context);
        ProcessServiceSession serviceSession = context.getProcessServiceSession();
        String processLabel = exception.getProcessId();
        if (exception.getProcessId() == null) {
            this.setKey(WebMsg.WAPI_2000);
        } else {
            try {
                Process process = serviceSession.processGet(exception.getProcessId());
                processLabel = process.getLabel(serviceSession.participantLocale());
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_2001(processLabel));
            }
        }
    }

    protected WapiProcessOperationException() {
    }
}

