/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessNotAvailableException;
import fuego.papi.ProcessServiceSession;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiProcessNotAvailableException
extends WapiOperationException {
    static final long serialVersionUID = -4283355529835441199L;
    static final long serialCheck = 6808153239267271421L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiProcessNotAvailableException(ProcessNotAvailableException exception, ErrorContext context) {
        this.init((OperationException)exception, context);
        ProcessServiceSession serviceSession = context.getProcessServiceSession();
        String processLabel = exception.getProcessId();
        if (exception.getProcessId() == null) {
            this.setKey(WebMsg.WAPI_0100);
        } else {
            try {
                Process process = serviceSession.processGet(exception.getProcessId());
                processLabel = process.getLabel(serviceSession.participantLocale());
            }
            catch (Exception e) {
                processLabel = exception.getProcessId();
            }
            finally {
                this.setKey(WebMsg.WAPI_0101(processLabel));
            }
        }
    }
}

