/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.OperationException;
import fuego.papi.ParticipantException;
import fuego.papi.ProcessServiceSession;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiParticipantException
extends WapiOperationException {
    static final long serialVersionUID = 6477297636782243577L;
    static final long serialCheck = 7864743507949221871L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiParticipantException(ParticipantException exception, ErrorContext context) {
        this.init((OperationException)exception, context);
        ProcessServiceSession serviceSession = context.getProcessServiceSession();
        String participantName = exception.getParticipantId();
        if (exception.getParticipantId() == null) {
            this.setKey(WebMsg.WAPI_1000);
        } else {
            try {
                participantName = serviceSession.participantFind(exception.getParticipantId()).getName();
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_1001(participantName));
            }
        }
    }

    protected WapiParticipantException() {
    }
}

