/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.Activity;
import fuego.papi.InstanceInfo;
import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessServiceSession;
import fuego.papi.exception.NoValidTransitionAvailableException;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiInstanceOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiNoValidTransitionAvailableException
extends WapiInstanceOperationException {
    static final long serialVersionUID = -3125968239190019523L;
    static final long serialCheck = -2317007199019160371L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiNoValidTransitionAvailableException(NoValidTransitionAvailableException exception, ErrorContext context) {
        this.init((OperationException)exception, context);
        String activityDesc = exception.getSourceActivityId();
        String instanceDesc = exception.getInstanceId();
        try {
            ProcessServiceSession serviceSession = context.getProcessServiceSession();
            InstanceInfo instance = serviceSession.processGetInstance(exception.getInstanceId());
            instanceDesc = instance.getDescription();
            Process process = serviceSession.processGet(instance.getProcessId());
            Activity activity = process.getActivity(exception.getSourceActivityId());
            activityDesc = activity.getLabel(serviceSession.participantLocale());
        }
        catch (Exception e) {
            Log.logWarning((Throwable)e);
        }
        finally {
            this.setKey(WebMsg.WAPI_3002(instanceDesc, activityDesc));
        }
    }
}

