/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.OperationException;
import fuego.papi.ProcessServiceSession;
import fuego.papi.exception.InstanceSelectedByOtherException;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiInstanceAlreadySelectedException;
import oracle.bpm.web.msg.WebMsg;

public class WapiInstanceSelectedByOtherException
extends WapiInstanceAlreadySelectedException {
    static final long serialVersionUID = -5042255065806296589L;
    static final long serialCheck = 5190545358341929978L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiInstanceSelectedByOtherException(InstanceSelectedByOtherException exception, ErrorContext context) {
        this.init((OperationException)exception, context);
        ProcessServiceSession session = context.getProcessServiceSession();
        String instanceDesc = exception.getInstanceId();
        String participantName = exception.getParticipantId();
        if (exception.getInstanceId() == null || exception.getParticipantId() == null) {
            this.setKey(WebMsg.WAPI_3025);
        } else {
            try {
                instanceDesc = session.processGetInstance(exception.getInstanceId()).getDescription();
                participantName = session.participantFind(exception.getParticipantId()).getName();
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_3026(instanceDesc, participantName));
            }
        }
    }
}

