/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.Activity;
import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessServiceSession;
import fuego.papi.exception.InstanceNotInActivityException;
import java.util.Locale;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiInstanceOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiInstanceNotInActivityException
extends WapiInstanceOperationException {
    static final long serialVersionUID = 916679732418633710L;
    static final long serialCheck = -1099872182091023876L;

    public WapiInstanceNotInActivityException(InstanceNotInActivityException exception, ErrorContext context) {
        this.init((OperationException)((Object)exception), context);
        ProcessServiceSession s = context.getProcessServiceSession();
        try {
            if (exception.getProcessId() != null && exception.getInstanceId() != null && exception.getCurrentActivity() != null && exception.getLastActivity() != null && !s.processGet(exception.getProcessId()).getActivity(exception.getCurrentActivity()).hasType(1)) {
                Locale locale = s.participantLocale();
                String instanceDesc = s.processGetInstance(exception.getInstanceId()).getDescription();
                Process process = s.processGet(exception.getProcessId());
                Activity currentActivity = process.getActivity(exception.getCurrentActivity());
                String currentActLabel = currentActivity.getLabel(locale);
                Activity lastActivity = process.getActivity(exception.getLastActivity());
                String lastActLabel = lastActivity.getLabel(locale);
                this.setKey(WebMsg.WAPI_3101(instanceDesc, lastActLabel, currentActLabel));
            } else {
                this.setKey(WebMsg.WAPI_3100);
            }
        }
        catch (Exception e) {
            Log.logWarning((Throwable)e);
            this.setKey(WebMsg.WAPI_3100);
        }
    }
}

