/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.InstanceInfo;
import fuego.papi.OperationException;
import fuego.papi.ProcessServiceSession;
import fuego.papi.exception.InstanceNotAvailableException;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiInstanceOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiInstanceNotAvailableException
extends WapiInstanceOperationException {
    static final long serialVersionUID = 2656252950128014322L;
    static final long serialCheck = 3001247659873684263L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiInstanceNotAvailableException(InstanceNotAvailableException exception, ErrorContext context) {
        this.init((OperationException)((Object)exception), context);
        String instanceDesc = exception.getInstanceId();
        if (exception.getInstanceId() == null) {
            this.setKey(WebMsg.WAPI_3080);
        } else {
            try {
                ProcessServiceSession session = context.getProcessServiceSession();
                InstanceInfo instanceInfo = session.processGetInstance(exception.getInstanceId());
                instanceDesc = instanceInfo.getDescription();
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_3081(instanceDesc));
            }
        }
    }
}

