/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.Activity;
import fuego.papi.InstanceInfo;
import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessServiceSession;
import fuego.papi.exception.InstanceConcurrentExecutionException;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiInstanceOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiInstanceConcurrentExecutionException
extends WapiInstanceOperationException {
    static final long serialVersionUID = 111832336942793196L;
    static final long serialCheck = -7392092756603298147L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiInstanceConcurrentExecutionException(InstanceConcurrentExecutionException exception, ErrorContext context) {
        this.init((OperationException)((Object)exception), context);
        ProcessServiceSession s = context.getProcessServiceSession();
        String activityLabel = exception.getProcessId();
        String instanceDesc = exception.getInstanceId();
        if (exception.getInstanceId() == null || exception.getActivity() == null) {
            this.setKey(WebMsg.WAPI_3070);
        } else {
            try {
                Process process = s.processGet(exception.getProcessId());
                Activity activity = process.getActivity(exception.getActivity());
                activityLabel = activity.getLabel(s.participantLocale());
                InstanceInfo instanceInfo = s.processGetInstance(exception.getInstanceId());
                instanceDesc = instanceInfo.getDescription();
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_3071(instanceDesc, activityLabel));
            }
        }
    }
}

