/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.OperationException;
import fuego.papi.ProcessServiceSession;
import fuego.papi.exception.InstanceAlreadySelectedException;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiInstanceOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiInstanceAlreadySelectedException
extends WapiInstanceOperationException {
    static final long serialVersionUID = 3696454494417208496L;
    static final long serialCheck = 4627501298922262719L;

    public WapiInstanceAlreadySelectedException() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiInstanceAlreadySelectedException(InstanceAlreadySelectedException exception, ErrorContext context) {
        this.init((OperationException)((Object)exception), context);
        ProcessServiceSession serviceSession = context.getProcessServiceSession();
        String instanceDesc = exception.getInstanceId();
        String participantName = exception.getParticipantId();
        if (exception.getInstanceId() == null || exception.getParticipantId() == null) {
            this.setKey(WebMsg.WAPI_3020);
        } else {
            try {
                instanceDesc = serviceSession.processGetInstance(exception.getInstanceId()).getDescription();
                participantName = serviceSession.participantFind(exception.getParticipantId()).getName();
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_3021(instanceDesc, participantName));
            }
        }
    }
}

