/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.Attachment;
import fuego.papi.OperationException;
import fuego.papi.ProcessServiceSession;
import fuego.papi.exception.CheckInAttachmentException;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiAttachmentOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiCheckInAttachmentException
extends WapiAttachmentOperationException {
    static final long serialVersionUID = -6601500496525224932L;
    static final long serialCheck = 5178502643057636805L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiCheckInAttachmentException(CheckInAttachmentException exception, ErrorContext context) {
        this.init((OperationException)exception, context);
        String attachmentDesc = exception.getAttachementId();
        if (exception.getAttachementId() == null) {
            this.setKey(WebMsg.WAPI_7080);
        } else {
            try {
                ProcessServiceSession session = context.getProcessServiceSession();
                Attachment attachment = session.attachmentGet(exception.getAttachementId());
                attachmentDesc = attachment.getDescription();
                this.setKey(WebMsg.WAPI_7081(attachmentDesc));
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_7081(attachmentDesc));
            }
        }
    }
}

