/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.OperationException;
import fuego.papi.ProcessServiceSession;
import fuego.papi.exception.CannotLockInstanceException;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiInstanceOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiCantLockInstanceException
extends WapiInstanceOperationException {
    static final long serialVersionUID = -2548853993700666121L;
    static final long serialCheck = 5356946457912951038L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiCantLockInstanceException(CannotLockInstanceException exception, ErrorContext context) {
        this.init((OperationException)((Object)exception), context);
        ProcessServiceSession serviceSession = context.getProcessServiceSession();
        String instanceDesc = exception.getInstanceId();
        String participantName = exception.getInstanceOwner();
        boolean isSameParticipant = exception.isSameParticipant();
        if (exception.getInstanceId() == null) {
            this.setKey(WebMsg.WAPI_3010);
        } else if (exception.getInstanceOwner() == null) {
            try {
                instanceDesc = serviceSession.processGetInstance(exception.getInstanceId()).getDescription();
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_3011(instanceDesc));
            }
        } else {
            try {
                instanceDesc = serviceSession.processGetInstance(exception.getInstanceId()).getDescription();
                participantName = serviceSession.participantFind(exception.getInstanceOwner()).getName();
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                if (isSameParticipant) {
                    this.setKey(WebMsg.WAPI_3013(instanceDesc));
                } else {
                    this.setKey(WebMsg.WAPI_3012(instanceDesc, participantName));
                }
            }
        }
    }
}

