/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessServiceSession;
import fuego.papi.exception.CannotCreateInstanceException;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiProcessOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiCannotCreateInstanceException
extends WapiProcessOperationException {
    static final long serialVersionUID = -7850829610314086872L;
    static final long serialCheck = -7286048035649069127L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiCannotCreateInstanceException(CannotCreateInstanceException exception, ErrorContext context) {
        this.init((OperationException)exception, context);
        ProcessServiceSession serviceSession = context.getProcessServiceSession();
        String processLabel = exception.getProcessId();
        String numberOfInstances = String.valueOf(exception.getMaxInstancesCount());
        if (exception.getProcessId() == null) {
            this.setKey(WebMsg.WAPI_2020);
        } else if (exception.getMaxInstancesCount() == -1) {
            try {
                Process process = serviceSession.processGet(exception.getProcessId());
                processLabel = process.getLabel(serviceSession.participantLocale());
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_2021(processLabel));
            }
        } else {
            try {
                Process process = serviceSession.processGet(exception.getProcessId());
                processLabel = process.getLabel(serviceSession.participantLocale());
                numberOfInstances = String.valueOf(exception.getMaxInstancesCount());
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_2022(processLabel, numberOfInstances));
            }
        }
    }
}

