/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.BatchOperationException;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiExceptionFactory;
import oracle.bpm.web.exception.WebException;
import oracle.bpm.web.msg.WebMsg;

public class WapiBatchOperationException
extends WebException {
    private Object[] availableObjects;
    private Map<String, Throwable> notAvailableObjects;
    static final long serialVersionUID = -313938732184052261L;
    static final long serialCheck = 484418910866780977L;

    public WapiBatchOperationException(BatchOperationException e, ErrorContext context) {
        this.setKey(WebMsg.WAPI_9000);
        this.notAvailableObjects = e.getNotAvailableObjects();
        this.availableObjects = e.getAvailableObjects();
        for (Map.Entry entry : e.getNotAvailableObjects().entrySet()) {
            this.notAvailableObjects.put((String)entry.getKey(), WapiExceptionFactory.create((Throwable)entry.getValue(), context));
        }
        this.initCause((Throwable)e);
    }

    public void setAvailableObjects(Object[] availableObjects) {
        this.availableObjects = availableObjects;
    }

    public Object[] getAvailableObjects() {
        return this.availableObjects;
    }

    public String getDetail(Locale locale) {
        String m = super.getDetail(locale);
        if (m == null) {
            return "";
        }
        int i = m.indexOf(":");
        return m.substring(i + 1, m.length());
    }

    public String getMessage(Locale locale) {
        return this.getUserMessage(locale);
    }

    public void setNotAvailableObjects(Map<String, Throwable> notAvailableObjects) {
        this.notAvailableObjects = notAvailableObjects;
    }

    public Map<String, Throwable> getNotAvailableObjects() {
        return this.notAvailableObjects;
    }

    public String getUserMessage(Locale locale) {
        String m = super.getUserMessage(locale);
        if (m == null) {
            return "";
        }
        int i = m.indexOf(":");
        return m.substring(i + 1, m.length());
    }

    public boolean failAll() {
        return this.availableObjects != null && this.notAvailableObjects != null && this.availableObjects.length == 0 && !this.notAvailableObjects.isEmpty();
    }
}

