/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.Activity;
import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessServiceSession;
import fuego.papi.exception.ActivityUserTimeoutException;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiTaskFailedException;
import oracle.bpm.web.msg.WebMsg;

public class WapiActivityUserTimeoutException
extends WapiTaskFailedException {
    static final long serialVersionUID = 2178829309343228054L;
    static final long serialCheck = -2195321083922265359L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiActivityUserTimeoutException(ActivityUserTimeoutException exception, ErrorContext context) {
        this.init((OperationException)((Object)exception), context);
        ProcessServiceSession session = context.getProcessServiceSession();
        String activityLabel = exception.getActivityId();
        if (exception.getActivityId() == null) {
            this.setKey(WebMsg.WAPI_3460);
        } else {
            try {
                if (exception.getProcessId() != null) {
                    Process process = session.processGet(exception.getProcessId());
                    Activity activity = process.getActivity(exception.getActivityId());
                    activityLabel = activity.getLabel(session.participantLocale());
                }
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_3459(activityLabel));
            }
        }
    }
}

