/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.Activity;
import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessServiceSession;
import fuego.papi.exception.ActivityTimeoutException;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiActivityFailedException;
import oracle.bpm.web.msg.WebMsg;

public class WapiActivityTimeoutException
extends WapiActivityFailedException {
    static final long serialVersionUID = 5675973973166225271L;
    static final long serialCheck = -1635164063943872783L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiActivityTimeoutException(ActivityTimeoutException exception, ErrorContext context) {
        this.init((OperationException)((Object)exception), context);
        ProcessServiceSession s = context.getProcessServiceSession();
        String activityLabel = exception.getActivityId();
        if (exception.getActivityId() == null) {
            this.setKey(WebMsg.WAPI_3454);
        } else {
            try {
                if (exception.getProcessId() != null) {
                    Process process = s.processGet(exception.getProcessId());
                    Activity activity = process.getActivity(exception.getActivityId());
                    activityLabel = activity.getLabel(s.participantLocale());
                }
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_3455(activityLabel));
            }
        }
    }
}

