/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import fuego.papi.Activity;
import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessServiceSession;
import fuego.papi.exception.ActivityFailedException;
import oracle.bpm.log.Log;
import oracle.bpm.web.exception.ErrorContext;
import oracle.bpm.web.exception.WapiProcessOperationException;
import oracle.bpm.web.msg.WebMsg;

public class WapiActivityFailedException
extends WapiProcessOperationException {
    static final long serialVersionUID = -1942316275144036332L;
    static final long serialCheck = 9897915878136488L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WapiActivityFailedException(ActivityFailedException exception, ErrorContext context) {
        this.init((OperationException)exception, context);
        ProcessServiceSession serviceSession = context.getProcessServiceSession();
        String activityLabel = exception.getActivityId();
        if (exception.getProcessId() == null || exception.getActivityId() == null) {
            this.setKey(WebMsg.WAPI_3452);
        } else {
            try {
                Process process = serviceSession.processGet(exception.getProcessId());
                Activity activity = process.getActivity(exception.getActivityId());
                activityLabel = activity.getLabel(serviceSession.participantLocale());
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
            finally {
                this.setKey(WebMsg.WAPI_3453(activityLabel));
            }
        }
    }

    protected WapiActivityFailedException() {
    }
}

