/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.exception;

import java.util.Locale;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.Utility;
import oracle.bpm.web.exception.WebException;
import oracle.bpm.web.msg.WebMsg;

public final class AttachmentException
extends WebException {
    static final long serialVersionUID = -4237218377699825754L;
    static final long serialCheck = -266886625350403101L;

    AttachmentException(Msg message) {
        super(message);
    }

    AttachmentException(Msg message, Throwable cause) {
        super(message, cause);
    }

    public static AttachmentException attachmentNoLongerEditable() {
        return new AttachmentException(WebMsg.WAM_00041);
    }

    public static AttachmentException attachmentNotExists() {
        return new AttachmentException(WebMsg.WAM_00012);
    }

    public static AttachmentException attachmentSizeExceeded(int maxSize, Locale locale) {
        return new AttachmentException(WebMsg.WAM_00054(Utility.getLocalizedSize((Locale)locale, (long)maxSize)));
    }

    public static AttachmentException invalidAttachment(Exception cause) {
        return new AttachmentException(WebMsg.WAM_00010, cause);
    }

    public static AttachmentException invalidAttachmentKey() {
        return new AttachmentException(WebMsg.WAM_00011);
    }
}

