/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.authentication;

import fuego.papi.OperationException;
import fuego.papi.ProcessServiceAdminSession;
import fuego.papi.ProcessServiceSession;
import fuego.papi.PropertyOperationException;
import fuego.papi.exception.NoPermissionException;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.StackTrace;
import oracle.bpm.web.authentication.UserOptions;
import oracle.bpm.web.execution.authentication.RuntimePrincipal;
import oracle.bpm.web.msg.WebMsg;

public class WebPrincipal
implements RuntimePrincipal {
    private boolean bChanged;
    private Boolean passwordExpiredValue;
    private ProcessServiceAdminSession processAdminSession_d;
    private ProcessServiceSession processSession_d;
    private UserOptions userOptions;
    private static final String OPTIONS_NAME = "OPTIONS";
    static final long serialVersionUID = -268994128982275554L;
    static final long serialCheck = -4293798612012675860L;

    public WebPrincipal() {
        try {
            Log.logSevere((Msg)WebMsg.WAM_00020("WamPrincipal is being initialized by its default constructor with a null ProcessServiceNESession. It might be that the Workspace session is being deserialized; please check that the 'sticky session' property is properly set in the load balancer.\n" + StackTrace.getStackTrace()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WebPrincipal(ProcessServiceSession processSession) {
        this.processSession_d = processSession;
        this.load();
    }

    public boolean isChangeParticipantPasswordSupported() {
        return this.getProcessServiceSession().participantChangePasswordEnabled();
    }

    public Locale getLocale() {
        return this.getUserOptions().getUserLocale();
    }

    public String getName() {
        return this.processSession_d.participantCurrent().getUid();
    }

    public boolean isProcessOwner() {
        String[] roleIds;
        for (String roleId : roleIds = this.processSession_d.participantCurrent().getRoles()) {
            if (!roleId.equalsIgnoreCase("processowner")) continue;
            return true;
        }
        return false;
    }

    public ProcessServiceSession getProcessServiceSession() {
        if (this.processSession_d == null) {
            throw new RuntimeException("processServiceSession is null. Your session is not valid. It might be that the Workspace session is being deserialized. Please, check the log for more information.");
        }
        return this.processSession_d;
    }

    public ProcessServiceAdminSession getProcessServiceAdminSession() throws NoPermissionException {
        if (this.processAdminSession_d == null) {
            this.processAdminSession_d = this.getProcessServiceSession().upgradeToAdminSession();
        }
        return this.processAdminSession_d;
    }

    public ResourceBundle getResourceBundleForImages() {
        return this.getUserOptions().getUserBundleForImages();
    }

    public ResourceBundle getResourceBundleForJSP() {
        return this.getUserOptions().getUserBundleForJSP();
    }

    public void setUserOptions(UserOptions userOptions) {
        this.userOptions = userOptions;
        this.bChanged = true;
    }

    public UserOptions getUserOptions() {
        return this.userOptions;
    }

    public void changePassword(String oldPassword, String newPassword) throws OperationException {
        if (!this.isChangeParticipantPasswordSupported()) {
            throw new UnsupportedOperationException("Operation not supported");
        }
        this.getProcessServiceSession().participantUpdatePassword(oldPassword, newPassword);
        this.updatePasswordExpiration();
    }

    public boolean connected() {
        return this.getProcessServiceSession() != null && this.getProcessServiceSession().isOpened();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof WebPrincipal)) {
            return false;
        }
        WebPrincipal webPrincipal = (WebPrincipal)object;
        return this.getName().equals(webPrincipal.getName()) && this.processSession_d.equals(webPrincipal.processSession_d);
    }

    public boolean hasExpiredPassword() {
        block3: {
            if (this.passwordExpiredValue == null) {
                try {
                    String pe = this.getProcessServiceSession().participantRetrieveProperty("PROFILE_CATEGORY", "PASSWORD_EXPIRED");
                    this.passwordExpiredValue = Boolean.valueOf(pe);
                }
                catch (OperationException e) {
                    this.passwordExpiredValue = Boolean.FALSE;
                    if (!Log.isDebugging()) break block3;
                    Log.logDebug((Throwable)e);
                }
            }
        }
        return this.passwordExpiredValue;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void load() {
        try {
            ProcessServiceSession session = this.getProcessServiceSession();
            Map properties = session.participantRetrieveProperties("WAM");
            String serializedOptions = (String)properties.get(OPTIONS_NAME);
            try {
                this.userOptions = UserOptions.valueOf(serializedOptions);
            }
            catch (IOException e) {
                Log.logWarning((Throwable)e);
            }
        }
        catch (ClassCastException classCastException) {
            Log.logFatal((Throwable)classCastException);
        }
        catch (PropertyOperationException poe) {
            Log.logFatal((Throwable)poe);
        }
        catch (OperationException oe) {
            Log.logFatal((Throwable)oe);
        }
        this.bChanged = false;
    }

    public void store() {
        try {
            if (this.getProcessServiceSession() != null && this.userOptions != null) {
                Map properties = this.getProcessServiceSession().participantRetrieveProperties("WAM");
                String serializedOptions = this.userOptions.getPropertiesAsString();
                if (properties != null) {
                    properties.put(OPTIONS_NAME, serializedOptions);
                    this.getProcessServiceSession().participantStoreProperties("WAM", properties);
                }
            }
            this.bChanged = false;
        }
        catch (OperationException e) {
            throw ProgramException.wrap((String)"Error trying to save participant properties", (Throwable)e);
        }
        catch (IOException e) {
            throw ProgramException.wrap((String)"Error trying to save participant properties", (Throwable)e);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        stringBuffer.append("-");
        stringBuffer.append(this.userOptions.toString());
        return stringBuffer.toString();
    }

    public void update() {
        if (this.bChanged) {
            this.store();
        }
    }

    public void updatePasswordExpiration() {
    }
}

