/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.authentication;

import fuego.directory.util.UserOptionsBase;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.util.Base64;
import oracle.bpm.web.ColumnType;
import oracle.bpm.web.SessionEnvironment;
import oracle.bpm.xml.DeserializationException;
import oracle.bpm.xml.XMLDeserializer;

public class UserOptions
extends UserOptionsBase
implements Serializable {
    public String name;
    public String namePropertyName = "ft.portal.userName";
    public String userId;
    public String userIdPropertyName = "ft.portal.userId";
    private transient SessionEnvironment sessionEnvironment;
    private static final long serialVersionUID = -2057523097282886673L;
    static final long serialCheck = 7313977332283852887L;

    public UserOptions(SessionEnvironment se) {
        this.numberOfInstances = 10;
        this.sessionEnvironment = se;
        this.setUserLocale(Locale.ENGLISH);
        this.initTransientData(this.sessionEnvironment);
    }

    public UserOptions(String uId, String first, SessionEnvironment se) {
        this.userId = uId;
        this.name = first;
        this.sessionEnvironment = se;
        this.setUserLocale(Locale.ENGLISH);
        this.numberOfInstances = 10;
        this.initTransientData(this.sessionEnvironment);
    }

    public UserOptions(String uId, String first, Locale newLocale, SessionEnvironment se) {
        this(uId, first, se);
        if (newLocale != null) {
            this.setUserLocale(newLocale);
            this.initTransientData(this.sessionEnvironment);
        }
    }

    protected UserOptions() {
    }

    public static <T> T deserializeFromString(String serializedObject, Class<T> clazz) throws DeserializationException {
        XMLDeserializer xmlDeserializer = new XMLDeserializer();
        byte[] buffer = serializedObject.getBytes();
        byte[] decodedBuffer = Base64.decode((byte[])buffer);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(decodedBuffer);
        DynamicObject dynamicObject = xmlDeserializer.parse((InputStream)byteArrayInputStream);
        return (T)dynamicObject.convertTo(clazz);
    }

    public static UserOptions valueOf(String serializedOptions) throws IOException {
        String[] strColumns;
        Properties userProperties = UserOptions.getProperties((String)serializedOptions);
        UserOptions userOptions = new UserOptions();
        userOptions.orderSort = userProperties.getProperty("fuego.useroptions.orderSort", userOptions.getSortOrder());
        userOptions.sortBy = userProperties.getProperty("fuego.useroptions.sortBy", userOptions.getSortBy());
        userOptions.auditTrailImageOrientation = userProperties.getProperty("fuego.useroptions.auditTrailImageOrientation", userOptions.getAuditTrailImageOrientation());
        userOptions.workspacePortletsPreferences = userProperties.getProperty("fuego.useroptions.workspacePortletsPreferences", userOptions.workspacePortletsPreferences);
        userOptions.userOptionVersion = userProperties.getProperty("fuego.useroptions.application.version");
        userOptions.userLocaleCountry = userProperties.getProperty("fuego.useroptions.userLocaleCountry", userOptions.userLocaleCountry);
        userOptions.userLocaleLanguage = userProperties.getProperty("fuego.useroptions.userLocaleLanguage", userOptions.userLocaleLanguage);
        userOptions.userLocaleVariant = userProperties.getProperty("fuego.useroptions.userLocaleVariant", userOptions.userLocaleVariant);
        userOptions.userLocalDirectoryString = userProperties.getProperty("fuego.useroptions.userLocalDirectoryString", userOptions.userLocalDirectoryString);
        userOptions.userTimeZoneID = userProperties.getProperty("fuego.useroptions.userTimeZoneID", userOptions.userTimeZoneID);
        userOptions.bShowTree = Boolean.valueOf(userProperties.getProperty("fuego.useroptions.ShowTree", "" + userOptions.bShowTree));
        userOptions.bUseApplet = Boolean.valueOf(userProperties.getProperty("fuego.useroptions.UseApplet", "" + userOptions.bUseApplet));
        userOptions.bUseAutoRefresh = Boolean.valueOf(userProperties.getProperty("fuego.useroptions.UseAutoRefresh", "" + userOptions.bUseAutoRefresh));
        userOptions.enableDHTMLSupport = Boolean.valueOf(userProperties.getProperty("fuego.useroptions.enableDHTMLSupport", "" + userOptions.enableDHTMLSupport));
        userOptions.followTheInstance = Boolean.valueOf(userProperties.getProperty("fuego.useroptions.followTheInstance", "" + userOptions.followTheInstance));
        userOptions.isAutoRefreshMenuOption = Boolean.valueOf(userProperties.getProperty("fuego.useroptions.isAutoRefreshMenuOption", "" + userOptions.isAutoRefreshMenuOption));
        userOptions.keepInstanceView = Boolean.valueOf(userProperties.getProperty("fuego.useroptions.keepInstanceView", "" + userOptions.keepInstanceView));
        userOptions.showHiddenViews = Boolean.valueOf(userProperties.getProperty("fuego.useroptions.showHiddenViews", "" + userOptions.showHiddenViews));
        userOptions.useRemoteScript = Boolean.valueOf(userProperties.getProperty("fuego.useroptions.useRemoteScript", "" + userOptions.useRemoteScript));
        userOptions.applicationsLayout_d = Integer.parseInt(userProperties.getProperty("fuego.useroptions.applicationsLayout", "" + userOptions.applicationsLayout_d));
        userOptions.bMinutesRefresh = Integer.parseInt(userProperties.getProperty("fuego.useroptions.MinutesRefresh", "" + userOptions.bMinutesRefresh));
        userOptions.dateFormatType = Integer.parseInt(userProperties.getProperty("fuego.useroptions.dateFormatType", "" + userOptions.dateFormatType));
        userOptions.maximumSearchesInHistory = Integer.parseInt(userProperties.getProperty("fuego.useroptions.maximumSearchesInHistory", "" + userOptions.maximumSearchesInHistory));
        userOptions.numberOfInstances = Integer.parseInt(userProperties.getProperty("fuego.useroptions.numberOfInstances", "" + userOptions.numberOfInstances));
        userOptions.processMenuType = Integer.parseInt(userProperties.getProperty("fuego.useroptions.processMenuType", "" + userOptions.processMenuType));
        userOptions.refreshTimeMin = Integer.parseInt(userProperties.getProperty("fuego.useroptions.refreshTimeMin", "" + userOptions.refreshTimeMin));
        userOptions.executionDialogWidth = userProperties.getProperty("fuego.useroptions.executionDialogWidth", userOptions.getExecutionDialogWidth());
        userOptions.executionDialogHeight = userProperties.getProperty("fuego.useroptions.executionDialogHeight", userOptions.getExecutionDialogHeight());
        String dialogMaximize = userProperties.getProperty("fuego.useroptions.executionDialogMaximize", String.valueOf(userOptions.getExecutionDialogMaximize()));
        userOptions.executionDialogMaximize = dialogMaximize != null ? Boolean.valueOf(Boolean.parseBoolean(dialogMaximize)) : null;
        String columns = userProperties.getProperty("fuego.useroptions.columns");
        if (columns != null && (strColumns = columns.split(",")).length == userOptions.columns.length) {
            for (int i = 0; i < strColumns.length; ++i) {
                userOptions.columns[i] = Boolean.valueOf(strColumns[i]);
            }
        }
        return userOptions;
    }

    public void initTransientData(SessionEnvironment se) {
        this.sessionEnvironment = se;
        this.setUserLocale(this.getUserLocale());
    }

    public boolean isColumnEnable(ColumnType columnType) {
        return this.columns[columnType.ordinal()];
    }

    public void setColumn(ColumnType columnType, boolean value) {
        this.columns[columnType.ordinal()] = value;
    }

    public void setUserLocale(Locale newLocale) {
        super.setUserLocale(newLocale);
        this.sessionEnvironment.setLocale(newLocale);
        this.userBundleForImages = this.sessionEnvironment.getResourceBundleForImages();
        this.userBundleForJSP = this.sessionEnvironment.getResourceBundleForJSP();
    }

    public String getSortOrder() {
        if (super.getSortOrder() == null) {
            this.setSortOrder("ASCENDING");
        }
        return super.getSortOrder();
    }

    public String getSortBy() {
        if (super.getSortBy() == null) {
            this.setSortBy("PREDEFINE_RECEIVED TIME");
        }
        return super.getSortBy();
    }

    public String getAuditTrailImageOrientation() {
        if (super.getAuditTrailImageOrientation() == null) {
            this.setAuditTrailImageOrientation("vertical");
        }
        return super.getAuditTrailImageOrientation();
    }
}

