/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.authentication;

import fuego.directory.util.UserOptionVersion;
import fuego.papi.OperationException;
import fuego.papi.ProcessService;
import fuego.papi.ProcessServiceSession;
import fuego.papi.exception.AbsentParticipantException;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import oracle.bpm.lang.ConnectionPassport;
import oracle.bpm.lang.MissingPropertyException;
import oracle.bpm.log.Log;
import oracle.bpm.web.BaseLoginUser;
import oracle.bpm.web.SessionEnvironment;
import oracle.bpm.web.WebEnvironment;
import oracle.bpm.web.authentication.UserOptions;
import oracle.bpm.web.authentication.WebPrincipal;
import oracle.bpm.web.exception.WapiAbsentParticipantException;

public class AuthenticationSessionManager {
    public static final String SESSION_PRINCIPAL = "fuego.web.principal";

    public static boolean isAuthenticatedSession(HttpSession session) {
        boolean authenticated = false;
        WebPrincipal principal = null;
        if (session != null) {
            principal = (WebPrincipal)session.getAttribute(SESSION_PRINCIPAL);
        }
        if (principal != null && principal.connected()) {
            authenticated = true;
        }
        return authenticated;
    }

    public static WebPrincipal authenticateSession(BaseLoginUser baseLoginUser, HttpServletRequest request, Locale userAgentLocale, String remoteHost) throws OperationException {
        HttpSession session = request.getSession();
        if (session == null) {
            throw new IllegalStateException("Session must be initialized");
        }
        ServletContext servletContext = session.getServletContext();
        SessionEnvironment sessionEnvironment = SessionEnvironment.getInstance(session, userAgentLocale);
        ProcessService service = (ProcessService)servletContext.getAttribute("fuego.web.service");
        ProcessServiceSession processSession = service.createSession(baseLoginUser.getUsername(), baseLoginUser.getPassword(), remoteHost);
        return AuthenticationSessionManager.createWebPrincipal(request, userAgentLocale, session, sessionEnvironment, processSession);
    }

    public static WebPrincipal authenticateSession(ConnectionPassport passport, HttpServletRequest request, Locale userAgentLocale, String remoteHost) throws OperationException, WapiAbsentParticipantException {
        ProcessServiceSession processSession;
        HttpSession session = request.getSession();
        if (session == null) {
            throw new IllegalStateException("Session must be initialized");
        }
        ServletContext servletContext = session.getServletContext();
        SessionEnvironment sessionEnvironment = SessionEnvironment.getInstance(session, userAgentLocale);
        ProcessService service = (ProcessService)servletContext.getAttribute("fuego.web.service");
        try {
            processSession = service.createSession(passport, remoteHost);
        }
        catch (AbsentParticipantException ape) {
            throw new WapiAbsentParticipantException(ape);
        }
        return AuthenticationSessionManager.createWebPrincipal(request, userAgentLocale, session, sessionEnvironment, processSession);
    }

    public static WebPrincipal authenticateSession(ConnectionPassport passport, HttpServletRequest request) throws OperationException, WapiAbsentParticipantException {
        return AuthenticationSessionManager.authenticateSession(passport, request, request.getLocale(), request.getRemoteHost());
    }

    public static WebPrincipal retrievePrincipal(HttpSession session) {
        WebPrincipal principal = null;
        if (session != null) {
            principal = (WebPrincipal)session.getAttribute(SESSION_PRINCIPAL);
        }
        return principal;
    }

    public static void unsetPrincipal(HttpSession session) {
        if (session != null) {
            session.removeAttribute(SESSION_PRINCIPAL);
        }
    }

    private static WebPrincipal createWebPrincipal(HttpServletRequest request, Locale userAgentLocale, HttpSession session, SessionEnvironment sessionEnvironment, final ProcessServiceSession processSession) throws OperationException {
        session.invalidate();
        session = request.getSession(true);
        SessionEnvironment.updateSessionEnvironment(session, sessionEnvironment);
        WebPrincipal principal = new WebPrincipal(processSession);
        UserOptions userOptions = AuthenticationSessionManager.initializeUserOptions(processSession, sessionEnvironment, userAgentLocale, session, principal);
        Locale currentLocale = userOptions.getUserLocale();
        TimeZone currentTimeZone = userOptions.getUserTimeZone();
        sessionEnvironment.setLocale(currentLocale);
        String sortBy = userOptions.getSortBy();
        if (sortBy != null) {
            processSession.viewsSetDefaultOrder(sortBy, "ASCENDING".equals(userOptions.getSortOrder()));
        }
        session.setAttribute("fuego.login.eventListener", (Object)new HttpSessionBindingListener(){

            public void valueBound(HttpSessionBindingEvent event) {
            }

            public void valueUnbound(HttpSessionBindingEvent event) {
                block3: {
                    try {
                        if (processSession.isOpened()) {
                            processSession.close();
                        }
                    }
                    catch (Throwable t) {
                        if (!Log.isDebugging()) break block3;
                        Log.logDebug((Throwable)t);
                    }
                }
            }
        });
        session.setAttribute(SESSION_PRINCIPAL, (Object)principal);
        return principal;
    }

    private static UserOptions initializeUserOptions(ProcessServiceSession processSession, SessionEnvironment sessionEnvironment, Locale userAgentLocale, HttpSession session, WebPrincipal principal) {
        UserOptions userOptions = principal.getUserOptions();
        if (userOptions == null) {
            block4: {
                userOptions = new UserOptions(processSession.participantCurrent().getUid(), processSession.participantCurrent().getName(), sessionEnvironment);
                userOptions.setUserLocale(userAgentLocale);
                userOptions.setUserOptionVersion(UserOptionVersion.ALPHA);
                try {
                    WebEnvironment env = WebEnvironment.getInstance(session.getServletContext());
                    String userLocalDirectory = env.getAttachmentLocalDir();
                    userOptions.setUserLocalDirectory(userLocalDirectory);
                }
                catch (MissingPropertyException ex) {
                    if (!Log.isDebugging()) break block4;
                    Log.logDebug((Throwable)ex);
                }
            }
            principal.setUserOptions(userOptions);
        } else {
            userOptions.initTransientData(sessionEnvironment);
        }
        return userOptions;
    }
}

