/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import oracle.bpm.lang.DefaultException;
import oracle.bpm.lang.DefaultRuntimeException;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Str;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.servlet.multipart.MultipartRequest;
import oracle.bpm.util.Base64;
import oracle.bpm.util.ExceptionFormatter;
import oracle.bpm.util.StackTrace;
import oracle.bpm.web.WebEnvironment;
import oracle.bpm.web.authentication.AuthenticationSessionManager;
import oracle.bpm.web.authentication.UserOptions;
import oracle.bpm.web.authentication.WebPrincipal;
import oracle.bpm.web.msg.WebMsg;
import oracle.bpm.xml.DeserializationException;
import oracle.bpm.xml.Serializer;
import oracle.bpm.xml.XMLDeserializer;
import oracle.bpm.xml.XMLSerializer;
import oracle.bpm.xml.XMLSerializerWriter;

public class WebUtils {
    private static Map<String, String> cssMap;
    private static final String CSS_EXTENSION = ".css";
    private static final String CSS_LANGUAGE_SEPARATOR = "-";

    private WebUtils() {
    }

    public static WebPrincipal getWebPrincipal(HttpSession httpSession) {
        return AuthenticationSessionManager.retrievePrincipal(httpSession);
    }

    public static String getPostState(HttpServletRequest httpServletRequest, String queryString, String[] excludedParameters) {
        StringBuilder postState = new StringBuilder();
        try {
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            if (queryString != null && !"".equals(queryString)) {
                Hashtable queryStringParam = new Hashtable();
                MultipartRequest.parseQueryString(queryStringParam, (String)queryString);
                Enumeration e = queryStringParam.keys();
                while (e.hasMoreElements()) {
                    String value;
                    String key = (String)e.nextElement();
                    String[] valueArr = (String[])queryStringParam.get(key);
                    if (valueArr == null || valueArr.length <= 0 || (value = valueArr[valueArr.length - 1]) == null) continue;
                    postParams.put(key, value);
                }
            }
            Enumeration enumeration = httpServletRequest.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String lineString;
                String parameterName = (String)enumeration.nextElement();
                String[] parameterValues = httpServletRequest.getParameterValues(parameterName);
                boolean excludeParameter = false;
                for (int j = 0; excludedParameters != null && j < excludedParameters.length; ++j) {
                    if (!excludedParameters[j].equals(parameterName)) continue;
                    excludeParameter = true;
                }
                if ("submit".equalsIgnoreCase(parameterName)) {
                    Log.logInfo((Msg)WebMsg.INVALID_PARAMETER_NAME);
                    excludeParameter = true;
                }
                if (excludeParameter) continue;
                Object redefinedParameter = httpServletRequest.getAttribute(parameterName);
                if (redefinedParameter != null && redefinedParameter instanceof String) {
                    lineString = "<input type=\"hidden\" name=\"" + parameterName + "\" value=\"" + redefinedParameter + "\">\n";
                    postState.append(lineString);
                    if (!Log.isDebugging()) continue;
                    Log.logDebug((String)"Redefined parameter");
                    continue;
                }
                for (String parameterValue : parameterValues) {
                    String queryParameterValue = (String)postParams.get(parameterName);
                    if (parameterValue.equals(queryParameterValue)) continue;
                    lineString = "<input type=\"hidden\" name=\"" + parameterName + "\" value=\"" + parameterValue + "\">\n";
                    postState.append(lineString);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return postState.toString();
    }

    public static TimeZone getTimeZoneFromParameter(String userTimeZone) {
        StringBuilder timeZoneID = new StringBuilder("GMT");
        try {
            if (userTimeZone.startsWith(CSS_LANGUAGE_SEPARATOR)) {
                timeZoneID.append("+");
                userTimeZone = userTimeZone.substring(1, userTimeZone.length());
            } else {
                timeZoneID.append(CSS_LANGUAGE_SEPARATOR);
            }
            int timeZoneInMinutes = Integer.parseInt(userTimeZone);
            int tzHours = Math.abs(timeZoneInMinutes / 60);
            int tzMinutes = Math.abs(timeZoneInMinutes % 60);
            DecimalFormat nf = new DecimalFormat("00");
            nf.setMinimumIntegerDigits(2);
            timeZoneID.append(tzHours);
            timeZoneID.append(":");
            timeZoneID.append(nf.format(tzMinutes));
            return TimeZone.getTimeZone(timeZoneID.toString());
        }
        catch (Exception e) {
            return TimeZone.getDefault();
        }
    }

    public static Object deserializeFromString(String serializedObject, Class<UserOptions> aClass) throws DeserializationException {
        XMLDeserializer xmlDeserializer = new XMLDeserializer();
        byte[] aBuffer = serializedObject.getBytes();
        byte[] aDecodedBuffer = Base64.decode((byte[])aBuffer);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(aDecodedBuffer);
        DynamicObject dynamicObject = xmlDeserializer.parse((InputStream)byteArrayInputStream);
        return dynamicObject.convertTo(aClass);
    }

    public static Msg keyToMsg(String msgKey, int iSize, String[] aString) {
        msgKey = Str.replace((String)msgKey, (String)CSS_LANGUAGE_SEPARATOR, (String)"_");
        Msg msg = null;
        try {
            msg = WebUtils.searchForMsg(iSize, WebMsg.class, msgKey, msg, aString);
            if (msg == null) {
                msg = WebUtils.searchForMsg(0, WebMsg.class, msgKey, msg, null);
            }
        }
        catch (IllegalAccessException e) {
            Log.logWarning((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.logWarning((Throwable)e);
        }
        return msg;
    }

    public static String serializeToString(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLSerializer xmlSerializer = new XMLSerializer();
        XMLSerializerWriter xmlWriter = new XMLSerializerWriter((OutputStream)byteArrayOutputStream, (Serializer)xmlSerializer);
        xmlWriter.write("object", DynamicObject.valueOf((Object)object));
        byte[] _aBuffer = Base64.encodeAsByteArray((byte[])byteArrayOutputStream.toByteArray());
        return new String(_aBuffer);
    }

    public static String getExceptionTechnicalDetail(Throwable exception, Locale locale) {
        if (exception == null) {
            String technicalDetail = StackTrace.getStackTrace();
            return technicalDetail;
        }
        String technicalDetail = exception instanceof DefaultException ? ((DefaultException)exception).getTechnicalDetail(locale) : (exception instanceof DefaultRuntimeException ? ((DefaultRuntimeException)exception).getTechnicalDetail(locale) : ExceptionFormatter.fullTechLevel((Throwable)exception));
        if (technicalDetail.length() > 1900) {
            technicalDetail = technicalDetail.substring(0, 1900);
            technicalDetail = technicalDetail + WebMsg.MORE_INFO.getString();
        }
        return technicalDetail;
    }

    public static String getExceptionMessageForUser(Throwable exception, Locale currentLocale) {
        return WebUtils.getExceptionMessageForUser(exception, currentLocale, null);
    }

    public static String getExceptionMessageForUser(Throwable exception, Locale currentLocale, Msg unexpeted) {
        String msg = "";
        if (exception instanceof DefaultException) {
            msg = ((DefaultException)exception).getUserMessage(currentLocale);
        } else if (exception instanceof DefaultRuntimeException) {
            msg = ((DefaultRuntimeException)exception).getUserMessage(currentLocale);
        } else if (exception != null) {
            msg = exception.getLocalizedMessage();
        }
        return msg;
    }

    public static String getExceptionHiddenForHidden(Throwable exception, Locale currentLocale) {
        return exception == null ? StackTrace.getStackTrace() : ExceptionFormatter.fullTechLevel((Throwable)exception);
    }

    public static String getExceptionHiddenForHidden(Throwable exception) {
        return WebUtils.getExceptionHiddenForHidden(exception, null);
    }

    public static String getExceptionDetail(Throwable exception, Locale locale) {
        String detail = "";
        if (exception == null) {
            return detail;
        }
        if (exception instanceof DefaultException) {
            detail = ((DefaultException)exception).getDetail(locale);
        } else if (exception instanceof DefaultRuntimeException) {
            detail = ((DefaultRuntimeException)exception).getDetail(locale);
        } else {
            detail = exception.toString();
            if (detail == null || detail.length() == 0) {
                detail = exception.getClass().getName();
            }
        }
        return detail;
    }

    public static boolean hasDetail(Throwable t) {
        if (t instanceof DefaultException) {
            DefaultException de = (DefaultException)t;
            return de.hasDetail();
        }
        if (t instanceof DefaultRuntimeException) {
            DefaultRuntimeException dre = (DefaultRuntimeException)t;
            return dre.hasDetail();
        }
        return true;
    }

    public static Msg logWarningErrorMessage(Throwable t) {
        return WebUtils.logWarningErrorMessage(t, null);
    }

    public static Msg logWarningErrorMessage(Throwable t, WebEnvironment environment) {
        String applicationId = environment != null ? environment.getApplicationId() : "BPM";
        String errorCode = applicationId + CSS_LANGUAGE_SEPARATOR + (System.currentTimeMillis() + (long)t.hashCode());
        Log.logWarning((Msg)WebMsg.LOG_ERROR(errorCode), (Throwable)t);
        return WebMsg.CLIENT_ERROR(errorCode);
    }

    public static boolean existPath(ServletContext context, String path) {
        boolean result;
        String realPath = context.getRealPath(path);
        if (realPath != null) {
            File cssFile = new File(realPath);
            result = cssFile.exists();
        } else {
            result = context.getResourceAsStream(path) != null;
        }
        return result;
    }

    public static String getCssFilename(ServletContext context, String contextPath, String filename, Locale locale) {
        String cssContextPath;
        assert (context != null) : "Context should not be null";
        assert (contextPath != null) : "filePath should not be null";
        if (cssMap == null) {
            cssMap = new HashMap<String, String>();
        }
        String language = locale == null ? Locale.US.getLanguage() : locale.getLanguage();
        StringBuilder cssKeyBuilder = new StringBuilder();
        cssKeyBuilder.append(context.getServletContextName());
        cssKeyBuilder.append(CSS_LANGUAGE_SEPARATOR);
        cssKeyBuilder.append(filename);
        cssKeyBuilder.append(CSS_LANGUAGE_SEPARATOR);
        cssKeyBuilder.append(language);
        String cssKey = cssKeyBuilder.toString();
        int extensionIndex = filename.indexOf(CSS_EXTENSION);
        String cssFilename = extensionIndex == -1 ? filename : filename.substring(0, extensionIndex);
        String string = cssContextPath = contextPath.charAt(contextPath.length() - 1) == '/' ? contextPath : contextPath.substring(0, contextPath.length() - 1);
        if (!cssMap.containsKey(cssKey)) {
            String localeCss = cssContextPath + cssFilename + CSS_LANGUAGE_SEPARATOR + language + CSS_EXTENSION;
            if (WebUtils.existPath(context, localeCss)) {
                cssMap.put(cssKey, cssFilename + CSS_LANGUAGE_SEPARATOR + language + CSS_EXTENSION);
            } else {
                Log.logDebug((Msg)WebMsg.DEFAULTING_TO_US_CSS(language));
                String englishCss = cssContextPath + cssFilename + CSS_LANGUAGE_SEPARATOR + Locale.US.getLanguage() + CSS_EXTENSION;
                if (WebUtils.existPath(context, englishCss)) {
                    cssMap.put(cssKey, cssFilename + CSS_LANGUAGE_SEPARATOR + Locale.US.getLanguage() + CSS_EXTENSION);
                } else {
                    cssMap.put(cssKey, cssFilename + CSS_EXTENSION);
                }
            }
        }
        return cssMap.get(cssKey);
    }

    public static InputStream getResourceAsStream(ServletContext sc, String path) throws FileNotFoundException {
        String realPath = sc.getRealPath(path);
        if (realPath != null) {
            File realPropertiesFile = new File(realPath);
            if (!realPropertiesFile.exists()) {
                throw new RuntimeException(path + " file could not be found! [" + realPath + "]");
            }
            return new FileInputStream(realPropertiesFile);
        }
        InputStream portalPropsStream = sc.getResourceAsStream(path);
        if (portalPropsStream == null) {
            throw new RuntimeException(path + " file could not be found! [" + realPath + "]");
        }
        return portalPropsStream;
    }

    public static String stringToJavaScriptLiteral(String text) {
        StringBuilder result = new StringBuilder();
        block10: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\\': {
                    result.append("\\\\");
                    continue block10;
                }
                case '\n': {
                    result.append("\\n");
                    continue block10;
                }
                case '\t': {
                    result.append("\\t");
                    continue block10;
                }
                case '\r': {
                    result.append("");
                    continue block10;
                }
                case '\b': {
                    result.append("\\b");
                    continue block10;
                }
                case '\f': {
                    result.append("\\f");
                    continue block10;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    result.append("\\'");
                    continue block10;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }

    public static String getDirectoryPath(ServletContext context, String path, boolean forceStructure) {
        String realPath = null;
        if (path != null) {
            try {
                realPath = context.getRealPath(path);
            }
            catch (Throwable e) {
                Log.logDebug((String)("Defaulting to java.io.tmpDir since: " + e.getMessage()));
            }
        }
        if (!WebUtils.isWritableDirectory(realPath)) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            File file = new File(tmpDir, forceStructure ? (path != null ? path : "") : "");
            realPath = file.getAbsolutePath();
        }
        return realPath;
    }

    public static boolean isWritableDirectory(String directory) {
        File directoryFile = null;
        if (directory != null) {
            directoryFile = new File(directory);
        }
        return directoryFile != null && directoryFile.isDirectory() && directoryFile.canWrite();
    }

    private static Msg searchForMsg(int iSize, Class<WebMsg> c, String msgKey, Msg msg, String[] args) throws IllegalAccessException, InvocationTargetException {
        if (iSize == 0) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.getName().equals(msgKey)) continue;
                field.setAccessible(true);
                msg = (Msg)field.get(null);
                break;
            }
        } else {
            for (Method method : c.getDeclaredMethods()) {
                if (!method.getName().equals(msgKey)) continue;
                method.setAccessible(true);
                msg = (Msg)method.invoke(null, (Object[])args);
                break;
            }
        }
        return msg;
    }
}

