/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import oracle.bpm.lang.DefaultEnvironment;
import oracle.bpm.lang.MissingPropertyException;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.ExceptionFormatter;
import oracle.bpm.util.Properties;
import oracle.bpm.web.WebUtils;
import oracle.bpm.web.msg.WebMsg;

public abstract class WebEnvironment
extends DefaultEnvironment {
    private Boolean xServerEnable_d;
    private static final String PROPERTY_SESSION_TIMEOUT = "sessionTimeOut";
    private static final String PROPERTY_ATTR_ATTACHMENT_LOCAL_DIR = "servlet.Attachment.DEFAULT_USER_LOCAL_DIRECTORY";
    private static final String PROPERTY_STYLESHEET = "stylesheet";
    private static final String PROPERTY_INSTANCE_CACHE_SIZE = "papi.instancesCacheSize";
    private static final String PROPERTY_ATTACHMENT_DEFAULT_LOCAL_DIRECTORY = "servlet.Attachment.DEFAULT_USER_LOCAL_DIRECTORY";
    private static final String X_SERVER_AVAILABLE = "fuego.web.xServerAvailable";
    private static final String APPLICATION_INSTANCE_KEY = "fuego.web.env";
    private static final String SSO_ENABLED = "enableSSO";
    private static final String SSO_LOGIN_CLASSNAME = "SSO.loginClassName";
    private static final String SSO_USERNAME_PATTERN = "SSO.usernamePattern";
    protected static final String PROPERTY_UPLOAD_DIR = "servlet.Attachment.UPLOAD_DIR";
    protected static final String PROPERTY_MAX_ATTACHMENT_SIZE = "servlet.Attachment.MAX_ATTACHMENT_SIZE";
    private static final String MAX_PARTICIPANTS = "papi.maxParticipants";

    public WebEnvironment(ServletContext context) {
        try {
            String appId = this.getApplicationId();
            this.setName(appId);
            Properties appProperties = this.getApplicationProperties(context);
            this.serProperties(appProperties);
            this.initializeLogSystem(appProperties);
        }
        catch (Exception e) {
            throw new RuntimeException(WebMsg.CANNOT_CREATE_DEFAULT_ENVIRONMENT.getString() + ExceptionFormatter.fullTechLevel((Throwable)e));
        }
    }

    public static WebEnvironment getInstance(ServletContext context) {
        WebEnvironment webEnvironment = (WebEnvironment)((Object)context.getAttribute(APPLICATION_INSTANCE_KEY));
        assert (webEnvironment != null) : "Web Environment must be previously initialized.";
        return webEnvironment;
    }

    public static WebEnvironment initialize(Class<?> clazz, ServletContext context) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Constructor<?> constructor = clazz.getConstructor(ServletContext.class);
        constructor.setAccessible(true);
        WebEnvironment environment = (WebEnvironment)((Object)constructor.newInstance(context));
        context.setAttribute(APPLICATION_INSTANCE_KEY, (Object)environment);
        return environment;
    }

    public void destroy() {
    }

    public String getAttachmentDefaultLocalDirectory() throws MissingPropertyException {
        return this.getProperty(this.buildKey("servlet.Attachment.DEFAULT_USER_LOCAL_DIRECTORY"));
    }

    public String getAttachmentLocalDir() throws MissingPropertyException {
        return this.getProperty(this.buildKey("servlet.Attachment.DEFAULT_USER_LOCAL_DIRECTORY"));
    }

    public String getUploadDir() throws MissingPropertyException {
        return this.getProperty(this.buildKey(PROPERTY_UPLOAD_DIR));
    }

    public int getAttachmentMaxSize() {
        return this.getIntegerProperty(this.buildKey(PROPERTY_MAX_ATTACHMENT_SIZE), 100000);
    }

    public String getCSSFile(ServletContext context, Locale locale) throws MissingPropertyException {
        String cssFilename = this.getProperty(this.buildKey(PROPERTY_STYLESHEET));
        return WebUtils.getCssFilename(context, "/css/", cssFilename, locale);
    }

    public String getCSSFile(ServletContext context, Locale locale, String cssFilename) throws MissingPropertyException {
        return WebUtils.getCssFilename(context, "/css/", cssFilename, locale);
    }

    public int getInstaceCacheSize(int defaultCache) {
        return this.getIntegerProperty(this.buildKey(PROPERTY_INSTANCE_CACHE_SIZE), defaultCache);
    }

    public int getMaxParticipants() {
        return this.getIntegerProperty(this.buildKey(MAX_PARTICIPANTS), 500);
    }

    public int getSessionTimeOut() throws MissingPropertyException {
        return this.getIntegerProperty(this.buildKey(PROPERTY_SESSION_TIMEOUT), -1);
    }

    public Properties getAllProperties() {
        Properties cloneProperties = new Properties();
        cloneProperties.putAll((Map)this.getMutableProperties());
        return cloneProperties;
    }

    public boolean isXServerSupported(HttpServletRequest req) {
        if (this.xServerEnable_d == null) {
            req.getSession(false);
            boolean ret = this.getBooleanProperty(X_SERVER_AVAILABLE, true);
            if (ret) {
                try {
                    GraphicsEnvironment.getLocalGraphicsEnvironment();
                }
                catch (Throwable ie) {
                    Log.logWarning((Msg)WebMsg.X_SERVER_CONNECTION_ERROR);
                    ret = false;
                }
            }
            this.xServerEnable_d = ret;
        }
        return this.xServerEnable_d;
    }

    public boolean isSSOEnabled() {
        return this.getBooleanProperty(this.buildKey(SSO_ENABLED), false);
    }

    public String getSSOLoginClassName() {
        return this.getProperty(this.buildKey(SSO_LOGIN_CLASSNAME), "");
    }

    public String getSSOUsernamePattern() {
        return this.getProperty(this.buildKey(SSO_USERNAME_PATTERN), null);
    }

    protected abstract String getApplicationId();

    protected abstract boolean isJSPBundleLoadRequired();

    protected abstract boolean isImageBundleLoadRequired();

    protected boolean isHelpBundleLoadRequired() {
        return false;
    }

    protected String buildKey(String keyPostfix) {
        StringBuilder result = new StringBuilder();
        result.append("fuego.").append(this.getApplicationId()).append(".").append(keyPostfix);
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getApplicationProperties(ServletContext context) throws IOException {
        String path = this.getPropertiesFile();
        Properties appProperties = new Properties();
        InputStream portalPropsStream = context.getResourceAsStream(path);
        if (portalPropsStream == null) {
            Log.logWarning((Msg)WebMsg.LOG_ERROR(path + " file could not be found! "));
        } else {
            try {
                appProperties.load(portalPropsStream);
            }
            finally {
                portalPropsStream.close();
            }
        }
        String remoteUrlStr = appProperties.getProperty(this.getApplicationId() + ".properties.remote.url", null);
        if (remoteUrlStr != null) {
            URL url = new URL(remoteUrlStr);
            InputStream is = url.openStream();
            try {
                appProperties.load(is);
            }
            finally {
                is.close();
            }
        }
        return appProperties;
    }

    String getPropertiesFile() {
        StringBuilder webApplicationProperties = new StringBuilder();
        webApplicationProperties.append("/WEB-INF/").append(this.getApplicationId()).append(".properties");
        return webApplicationProperties.toString();
    }

    private void initializeLogSystem(Properties appProperties) {
        String appId = this.getApplicationId();
        String logSeverities = appProperties.getProperty("oracle.bpm.log." + appId + ".severities", "");
        this.putProperty("oracle.bpm.log." + appId + ".clientSeverities", logSeverities);
    }
}

