/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web;

import java.io.IOException;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.bpm.web.WebUtils;

public class UserAgentInfo
implements Serializable {
    private boolean javaPluginEnabled_d = false;
    private TimeZone timeZone_d = TimeZone.getDefault();
    public static String ATTRIBUTE_USERAGENTINFO = "fuego.portal.useragentinfo";
    public static String FIELD_USERAGENTINFO = "useragentinfo";
    public static String FIELD_JAVAPLUGINENABLED = "useragentinfojavapluginenabled";
    public static String FIELD_TIMEZONE = "useragentinfotimezone";
    public static final int UNKNOWN = -1;
    public static final int MSIE = 0;
    public static final int OPERA = 1;
    public static final int NS6 = 2;
    public static final int NS7 = 3;
    public static final int NS4 = 4;
    static final long serialVersionUID = 5266938872308501943L;
    static final long serialCheck = 8130095511087340222L;

    public UserAgentInfo(String javaPluginEnabled, TimeZone timeZone) {
        this(Boolean.valueOf(javaPluginEnabled), timeZone);
    }

    public UserAgentInfo(boolean javaPluginEnabled, TimeZone timeZone) {
        this.setJavaPluginEnabled(javaPluginEnabled);
        this.setTimeZone(timeZone);
    }

    public static int getBrowserVendor(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null) {
            String user = userAgent.toLowerCase();
            if (user.indexOf("msie") != -1) {
                return 0;
            }
            if (user.indexOf("mozilla/5.0") != -1) {
                return 3;
            }
            if (user.indexOf("netscape6") != -1) {
                return 2;
            }
            if (userAgent.indexOf("opera") != -1) {
                return 1;
            }
            if (userAgent.indexOf("4.7") != -1) {
                return 4;
            }
        }
        return -1;
    }

    public static UserAgentInfo getUserAgentInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return null;
        }
        UserAgentInfo userAgentInfo = UserAgentInfo.getUserAgentInfoFromSession(httpSession);
        if (userAgentInfo == null) {
            userAgentInfo = UserAgentInfo.getUserAgentInfoFromCookie(httpServletRequest);
            if (userAgentInfo == null && (userAgentInfo = UserAgentInfo.getUserAgentInfoFromParameter(httpServletRequest)) != null) {
                UserAgentInfo.setUserAgentInfoOnCookie(userAgentInfo, httpServletRequest, httpServletResponse);
            }
            if (userAgentInfo != null) {
                UserAgentInfo.setUserAgentInfoOnSession(userAgentInfo, httpSession);
            }
        }
        return userAgentInfo;
    }

    public static boolean supportDOM(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        boolean isNs7 = false;
        boolean isNs6 = false;
        boolean isIE = false;
        if (userAgent != null) {
            String user = userAgent.toLowerCase();
            if (user.indexOf("msie") != -1) {
                isIE = true;
            } else if (user.indexOf("mozilla/5.0") != -1) {
                isNs7 = true;
            } else if (user.indexOf("netscape6") != -1) {
                isNs6 = true;
            }
        }
        return isNs6 || isIE || isNs7;
    }

    public void setJavaPluginEnabled(boolean javaPluginEnabled) {
        this.javaPluginEnabled_d = javaPluginEnabled;
    }

    public boolean getJavaPluginEnabled() {
        return this.javaPluginEnabled_d;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone_d = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone_d;
    }

    public String toString() {
        return "[javaPluginEnable_d:" + this.javaPluginEnabled_d + "],[timeZone:" + this.timeZone_d.getDisplayName(Locale.ENGLISH) + "]";
    }

    private static UserAgentInfo getUserAgentInfoFromCookie(HttpServletRequest httpServletRequest) throws IOException {
        boolean hasUserAgentInfo = false;
        String javaPluginEnabled = null;
        TimeZone timeZone = null;
        Cookie[] cookies = httpServletRequest.getCookies();
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            String propertyName = cookie.getName();
            String propertyValue = cookie.getValue();
            if (FIELD_USERAGENTINFO.equals(propertyName)) {
                hasUserAgentInfo = true;
            }
            if (FIELD_TIMEZONE.equals(propertyName)) {
                timeZone = TimeZone.getTimeZone(URLDecoder.decode(propertyValue, "UTF-8"));
                continue;
            }
            if (!FIELD_JAVAPLUGINENABLED.equals(propertyName)) continue;
            javaPluginEnabled = propertyValue;
        }
        return hasUserAgentInfo ? new UserAgentInfo(javaPluginEnabled, timeZone) : null;
    }

    private static UserAgentInfo getUserAgentInfoFromParameter(HttpServletRequest httpServletRequest) {
        UserAgentInfo userAgentInfo = null;
        if (httpServletRequest.getParameter(FIELD_USERAGENTINFO) != null) {
            String javaPluginEnabled = httpServletRequest.getParameter(FIELD_JAVAPLUGINENABLED);
            String timeZone = httpServletRequest.getParameter(FIELD_TIMEZONE);
            userAgentInfo = new UserAgentInfo(javaPluginEnabled, WebUtils.getTimeZoneFromParameter(timeZone));
        }
        return userAgentInfo;
    }

    private static UserAgentInfo getUserAgentInfoFromSession(HttpSession httpSession) {
        UserAgentInfo userAgentInfo = null;
        Object object = httpSession.getAttribute(ATTRIBUTE_USERAGENTINFO);
        if (object instanceof UserAgentInfo) {
            userAgentInfo = (UserAgentInfo)object;
        }
        return userAgentInfo;
    }

    private static boolean setUserAgentInfoOnCookie(UserAgentInfo userAgentInfo, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Cookie cookie = new Cookie(FIELD_USERAGENTINFO, "true");
        cookie.setMaxAge(-1);
        cookie.setPath(httpServletRequest.getContextPath());
        httpServletResponse.addCookie(cookie);
        cookie = new Cookie(FIELD_JAVAPLUGINENABLED, String.valueOf(userAgentInfo.getJavaPluginEnabled()));
        cookie.setMaxAge(-1);
        cookie.setPath(httpServletRequest.getContextPath());
        httpServletResponse.addCookie(cookie);
        String timeZoneId = userAgentInfo.getTimeZone().getID();
        cookie = new Cookie(FIELD_TIMEZONE, URLEncoder.encode(timeZoneId, "UTF-8"));
        cookie.setMaxAge(-1);
        cookie.setPath(httpServletRequest.getContextPath());
        httpServletResponse.addCookie(cookie);
        return true;
    }

    private static boolean setUserAgentInfoOnSession(UserAgentInfo userAgentInfo, HttpSession httpSession) {
        httpSession.setAttribute(ATTRIBUTE_USERAGENTINFO, (Object)userAgentInfo);
        return true;
    }
}

