/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import oracle.bpm.lang.MissingPropertyException;
import oracle.bpm.locale.LocaleBundleUtil;
import oracle.bpm.web.WebEnvironment;

public class SessionEnvironment {
    private WebEnvironment environment;
    private Locale locale;
    private ResourceBundle resourceBundleForHelp;
    private ResourceBundle resourceBundleForImages;
    private ResourceBundle resourceBundleForJSP;
    static String appName = null;
    private static String SESSION_ENVIRONMENT = "fuego.sessionEnvironment";

    public SessionEnvironment(WebEnvironment environment) {
        this.environment = environment;
    }

    public static SessionEnvironment getInstance(HttpSession session, HttpServletRequest request) {
        return SessionEnvironment.getInstance(session, request.getLocale());
    }

    public static SessionEnvironment getInstance(HttpSession session, Locale userAgentLocale) {
        Locale sessionLocale;
        SessionEnvironment sessionEnvironment = (SessionEnvironment)session.getAttribute(SESSION_ENVIRONMENT);
        if (sessionEnvironment == null) {
            WebEnvironment webEnvironment = WebEnvironment.getInstance(session.getServletContext());
            sessionEnvironment = new SessionEnvironment(webEnvironment);
        }
        if ((sessionLocale = sessionEnvironment.getLocale()) == null || !sessionLocale.equals(userAgentLocale)) {
            sessionEnvironment.setLocale(userAgentLocale);
            session.setAttribute(SESSION_ENVIRONMENT, (Object)sessionEnvironment);
        }
        return sessionEnvironment;
    }

    public static void updateSessionEnvironment(HttpSession session, SessionEnvironment environment) {
        session.setAttribute(SESSION_ENVIRONMENT, (Object)environment);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        try {
            if (this.environment.isImageBundleLoadRequired()) {
                this.setResourceBundleForImages(this.getBundle("imageBundleFile"));
            }
            if (this.environment.isJSPBundleLoadRequired()) {
                this.setResourceBundleForJSP(this.getBundle("jspBundleFile"));
            }
            if (this.environment.isHelpBundleLoadRequired()) {
                this.setResourceBundleForHelp(this.getBundle("helpBundleFile"));
            }
        }
        catch (MissingPropertyException mpe) {
            this.setResourceBundleForImages(ResourceBundle.getBundle("ImagesBundle", locale));
            this.setResourceBundleForJSP(ResourceBundle.getBundle("JSPBundle", locale));
            this.setResourceBundleForHelp(ResourceBundle.getBundle("HelpBundle", locale));
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Deprecated
    public String getProperty(String propertyName) throws MissingPropertyException {
        if (this.environment != null) {
            return this.environment.getProperty(propertyName);
        }
        throw new MissingPropertyException(propertyName);
    }

    public ResourceBundle getResourceBundleForImages() {
        return this.resourceBundleForImages;
    }

    public ResourceBundle getResourceBundleForJSP() {
        return this.resourceBundleForJSP;
    }

    public ResourceBundle getResourceBundleForHelp() {
        return this.resourceBundleForHelp;
    }

    private void setResourceBundleForImages(ResourceBundle newResourceBundle) {
        this.resourceBundleForImages = newResourceBundle;
    }

    private void setResourceBundleForJSP(ResourceBundle newResourceBundle) {
        this.resourceBundleForJSP = newResourceBundle;
    }

    private void setResourceBundleForHelp(ResourceBundle newResourceBundle) {
        this.resourceBundleForHelp = newResourceBundle;
    }

    private ResourceBundle getBundle(String bundlePropertyKeyPostfix) throws MissingPropertyException {
        String bundleKey = this.environment.buildKey(bundlePropertyKeyPostfix);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return LocaleBundleUtil.resolveBundleInClassLoader((String)this.environment.getProperty(bundleKey), (Locale)this.getLocale(), (ClassLoader)contextClassLoader);
    }
}

