/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import oracle.bpm.log.Log;

public class EncodedCookie
implements Cloneable {
    private Cookie cookie_d;

    public EncodedCookie(Cookie cookie) {
        this.cookie_d = cookie;
    }

    public EncodedCookie(String name, String value) {
        try {
            this.cookie_d = new Cookie(name, URLEncoder.encode(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Log.logFatal((Throwable)e);
        }
    }

    public void setComment(String purpose) {
        this.cookie_d.setComment(purpose);
    }

    public String getComment() {
        return this.cookie_d.getComment();
    }

    public void setCookie(Cookie cookie) {
        this.cookie_d = cookie;
        this.setValue(cookie.getValue());
    }

    public Cookie getCookie() {
        return this.cookie_d;
    }

    public void setDomain(String pattern) {
        this.cookie_d.setDomain(pattern);
    }

    public String getDomain() {
        return this.cookie_d.getDomain();
    }

    public void setMaxAge(int expiry) {
        this.cookie_d.setMaxAge(expiry);
    }

    public int getMaxAge() {
        return this.cookie_d.getMaxAge();
    }

    public String getName() {
        return this.cookie_d.getName();
    }

    public void setPath(String uri) {
        this.cookie_d.setPath(uri);
    }

    public String getPath() {
        return this.cookie_d.getPath();
    }

    public void setSecure(boolean flag) {
        this.cookie_d.setSecure(flag);
    }

    public boolean getSecure() {
        return this.cookie_d.getSecure();
    }

    public void setValue(String newValue) {
        try {
            this.cookie_d.setValue(URLEncoder.encode(newValue, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Log.logFatal((Throwable)e);
        }
    }

    public String getValue() {
        String temp = null;
        try {
            temp = URLDecoder.decode(this.cookie_d.getValue(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.logWarning((Throwable)e);
        }
        return temp;
    }

    public void setVersion(int v) {
        this.cookie_d.setVersion(v);
    }

    public int getVersion() {
        return this.cookie_d.getVersion();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

