/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web;

import fuego.directory.DirectoryConfigurationManager;
import fuego.directory.DirectoryPassport;
import fuego.papi.ProcessService;
import fuego.sso.SSOLoginException;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.bpm.lang.ConnectionPassport;
import oracle.bpm.log.Log;
import oracle.bpm.web.SSOUserLoginInterface;

public class BaseLoginUser
implements Serializable {
    boolean isSSO;
    String password;
    String username;
    private static SSOUserLoginInterface ssoUserLogin;
    static final long serialCheck = 2939562947953026019L;
    static final long serialVersionUID = 7311397601541485877L;

    public static BaseLoginUser createForSSO(String ssoLoginClassName, HttpServletRequest request, HttpServletResponse response) throws SSOLoginException {
        try {
            BaseLoginUser result = new BaseLoginUser();
            if (Log.isDebugging()) {
                Log.logDebug((String)("Session not authenticated. Authenticating using SSO class " + ssoLoginClassName));
            }
            ssoUserLogin = (SSOUserLoginInterface)Class.forName(ssoLoginClassName).newInstance();
            result.setUsername(ssoUserLogin.getUser(request, response));
            boolean skipFDIAuth = ssoUserLogin.skipFDIAuthentication();
            result.setSSO(skipFDIAuth);
            if (Log.isDebugging()) {
                Log.logDebug((String)("SSO class returned user " + result.getUsername() + (skipFDIAuth ? ", skipping FDI authentication." : ", using FDI authentication. Asking for password.")));
            }
            if (!skipFDIAuth) {
                result.setPassword(ssoUserLogin.getPassword(request, response));
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new SSOLoginException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SSOLoginException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new SSOLoginException((Throwable)e);
        }
    }

    public static String getLogoutURL() {
        if (ssoUserLogin == null) {
            return null;
        }
        String redirectURL = ssoUserLogin.getLogoutURL();
        if (redirectURL == null || "".equals(redirectURL)) {
            return null;
        }
        return redirectURL;
    }

    public static String getLogoutRelativePath() {
        if (ssoUserLogin == null) {
            return null;
        }
        String relativePath = ssoUserLogin.getLogoutRelativePath();
        if (relativePath == null || "".equals(relativePath)) {
            return null;
        }
        return relativePath;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isSSO() {
        return this.isSSO;
    }

    public void setSSO(boolean isSSO) {
        this.isSSO = isSSO;
    }

    public ConnectionPassport createPassport(ProcessService processService) {
        ConnectionPassport passport = processService.createPassport(this.getUsername());
        this.initConnectionPassport(passport);
        return passport;
    }

    public ConnectionPassport createPassport(String directoryId) {
        DirectoryPassport passport = DirectoryPassport.createWithID((String)directoryId, (String)this.getUsername());
        this.initConnectionPassport((ConnectionPassport)passport);
        return passport;
    }

    private void initConnectionPassport(ConnectionPassport passport) {
        if (Log.isDebugging()) {
            Log.logDebug((String)("Creating passport for participant " + this.getUsername() + (this.isSSO ? " with skip auth." : "")));
        }
        if (this.isSSO()) {
            DirectoryConfigurationManager manager = DirectoryConfigurationManager.getRuntime((String)passport.getId());
            manager.setProperty("skip-auth", "true");
        } else {
            passport.setPassword(this.getPassword());
        }
        passport.fillPassport();
    }
}

