/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.model.persistence;

import oracle.bpm.casemgmt.model.IdentityType;
import oracle.bpm.casemgmt.model.Resource;
import oracle.bpm.casemgmt.model.Translatable;
import oracle.bpm.casemgmt.model.TranslatableType;
import oracle.bpm.casemgmt.model.Value;
import oracle.bpm.casemgmt.model.cm.jaxb.ObjectFactory;
import oracle.bpm.casemgmt.model.cm.jaxb.TResource;
import oracle.bpm.casemgmt.model.cm.jaxb.TResourceIdentityType;
import oracle.bpm.casemgmt.model.cm.jaxb.TStaticOrXPath;
import oracle.bpm.casemgmt.model.cm.jaxb.TStaticOrXpathType;
import oracle.bpm.casemgmt.model.cm.jaxb.TTranslatableValue;
import oracle.bpm.casemgmt.model.cm.jaxb.TTranslatableValueTypeEnum;
import oracle.bpm.lang.Str;

public abstract class CommonWriter {
    static final ObjectFactory COMMON_FACTORY = new ObjectFactory();

    protected CommonWriter() {
    }

    protected TTranslatableValue translate(Translatable translatable) {
        TTranslatableValue result = null;
        if (translatable != null && !Str.isEmpty(translatable.getValue())) {
            Translatable.Resource resource;
            Translatable.Params params;
            result = COMMON_FACTORY.createTTranslatableValue();
            result.setTranslationType(this.translate(translatable.getTranslatableType()));
            result.setTranslationValue(translatable.getValue());
            if (translatable.getTranslatableType().isResource() && (params = (resource = translatable.toResource()).getParams()) != null && !params.isEmpty()) {
                result.getTranslationParam().addAll(params);
            }
        }
        return result;
    }

    protected TTranslatableValueTypeEnum translate(TranslatableType type) {
        TTranslatableValueTypeEnum result;
        switch (type) {
            case STATIC: {
                result = TTranslatableValueTypeEnum.STATIC;
                break;
            }
            case RESOURCE: {
                result = TTranslatableValueTypeEnum.RESOURCE;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    protected TResource translate(Resource resource) {
        TResource result = null;
        if (resource != null) {
            result = COMMON_FACTORY.createTResource();
            result.setIdentityType(this.translate(resource.getIdentityType()));
            result.setApplicationContext(resource.getApplicationContext());
            result.setSystemAttribute(resource.getSystemAttribute());
            Value value = resource.getValue();
            result.setType(value.getType().isStatic() ? TStaticOrXpathType.STATIC : TStaticOrXpathType.XPATH);
            result.setValue(value.getValue());
        }
        return result;
    }

    protected TResourceIdentityType translate(IdentityType type) {
        TResourceIdentityType result;
        switch (type) {
            case USER: {
                result = TResourceIdentityType.USER;
                break;
            }
            case GROUP: {
                result = TResourceIdentityType.GROUP;
                break;
            }
            case APPLICATION_ROLE: {
                result = TResourceIdentityType.APPLICATION_ROLE;
                break;
            }
            case PROCESS_ROLE: {
                result = TResourceIdentityType.PROCESS_ROLE;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    protected TStaticOrXPath translate(Value value) {
        TStaticOrXPath result = null;
        if (value != null) {
            result = COMMON_FACTORY.createTStaticOrXPath();
            result.setType(value.getType().isStatic() ? TStaticOrXpathType.STATIC : TStaticOrXpathType.XPATH);
            result.setValue(value.getValue());
        }
        return result;
    }
}

