/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.model.persistence;

import java.util.List;
import oracle.bpm.casemgmt.model.CommonFactory;
import oracle.bpm.casemgmt.model.IdentityType;
import oracle.bpm.casemgmt.model.Resource;
import oracle.bpm.casemgmt.model.Translatable;
import oracle.bpm.casemgmt.model.Value;
import oracle.bpm.casemgmt.model.cm.jaxb.TResource;
import oracle.bpm.casemgmt.model.cm.jaxb.TResourceIdentityType;
import oracle.bpm.casemgmt.model.cm.jaxb.TStaticOrXPath;
import oracle.bpm.casemgmt.model.cm.jaxb.TStaticOrXpathType;
import oracle.bpm.casemgmt.model.cm.jaxb.TTranslatableValue;

public abstract class CommonLoader {
    protected CommonLoader() {
    }

    protected Translatable translate(TTranslatableValue tTranslatableValue) {
        Translatable result = CommonFactory.createTranslatable();
        if (tTranslatableValue != null && tTranslatableValue.isSetTranslationType()) {
            switch (tTranslatableValue.getTranslationType()) {
                case STATIC: {
                    result.toStatic();
                    break;
                }
                case RESOURCE: {
                    result.toResource().setParams(this.translate(tTranslatableValue.getTranslationParam()));
                }
            }
            result.setValue(tTranslatableValue.getTranslationValue());
        }
        return result;
    }

    protected Translatable.Params translate(List<String> list) {
        Translatable.Params result = CommonFactory.createParams();
        if (!list.isEmpty()) {
            result.addAll(list);
        }
        return result;
    }

    protected Resource translate(TResource tResource) {
        Resource result = null;
        if (tResource != null) {
            result = CommonFactory.createResource();
            result.setIdentityType(this.translate(tResource.getIdentityType()));
            result.setApplicationContext(tResource.getApplicationContext());
            result.setSystemAttribute(tResource.getSystemAttribute());
            Value value = this.translate((TStaticOrXPath)tResource);
            if (value != null) {
                result.setValue(value);
            }
        }
        return result;
    }

    protected IdentityType translate(TResourceIdentityType type) {
        IdentityType result;
        switch (type) {
            case USER: {
                result = IdentityType.USER;
                break;
            }
            case GROUP: {
                result = IdentityType.GROUP;
                break;
            }
            case APPLICATION_ROLE: {
                result = IdentityType.APPLICATION_ROLE;
                break;
            }
            case PROCESS_ROLE: {
                result = IdentityType.PROCESS_ROLE;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    protected Value translate(TStaticOrXPath staticOrXPath) {
        Value result = null;
        if (staticOrXPath != null) {
            result = CommonFactory.createValue();
            TStaticOrXpathType type = staticOrXPath.getType();
            String value = staticOrXPath.getValue();
            if (TStaticOrXpathType.STATIC.equals((Object)type)) {
                result.toStatic().setValue(value);
            } else if (TStaticOrXpathType.XPATH.equals((Object)type)) {
                result.toXPath().setValue(value);
            }
        }
        return result;
    }
}

