/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.model.impl;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.impl.MapEntityImpl;
import oracle.bpm.util.Locales;
import oracle.bpm.util.Properties;
import org.jetbrains.annotations.Nullable;

public class PropertyBundleImpl
extends MapEntityImpl<String, String>
implements PropertyBundle {
    private static final long serialVersionUID = 5199611154628360814L;

    public PropertyBundleImpl(String nameWithLocale) {
        int index;
        Locale locale = null;
        String fullName = nameWithLocale;
        if (nameWithLocale.endsWith(".properties") && (index = nameWithLocale.lastIndexOf(46)) > 0) {
            fullName = fullName.substring(0, index);
        }
        if ((index = fullName.indexOf(95)) != -1) {
            String sLocale = fullName.substring(index + 1);
            locale = Locales.valueOf(sLocale);
        }
        this.setLocale(locale);
    }

    public PropertyBundleImpl(@Nullable Locale locale) {
        this.setLocale(locale);
    }

    @Override
    public Locale getLocale() {
        return this.getAttr(PropertyBundle.Metadata.LOCALE);
    }

    @Override
    public Properties createProperties() {
        Properties result = new Properties();
        Map<String, String> map = this.getAttr(PropertyBundle.Metadata.VALUES);
        Set<Map.Entry<String, String>> entries = map.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public void putAll(java.util.Properties properties) {
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            this.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    protected Map<String, String> getMap() {
        return this.getAttr(PropertyBundle.Metadata.VALUES);
    }

    private void setLocale(Locale locale) {
        this.setAttr(PropertyBundle.Metadata.LOCALE, locale);
    }
}

