/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.model.cm.persistence;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.casemgmt.model.DataType;
import oracle.bpm.casemgmt.model.Resource;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.CaseData;
import oracle.bpm.casemgmt.model.cm.Category;
import oracle.bpm.casemgmt.model.cm.Data;
import oracle.bpm.casemgmt.model.cm.EcmFolder;
import oracle.bpm.casemgmt.model.cm.Events;
import oracle.bpm.casemgmt.model.cm.Milestone;
import oracle.bpm.casemgmt.model.cm.Milestones;
import oracle.bpm.casemgmt.model.cm.NamespacePrefixes;
import oracle.bpm.casemgmt.model.cm.Outcomes;
import oracle.bpm.casemgmt.model.cm.PermissionRole;
import oracle.bpm.casemgmt.model.cm.Permissions;
import oracle.bpm.casemgmt.model.cm.StakeHolder;
import oracle.bpm.casemgmt.model.cm.StakeHolders;
import oracle.bpm.casemgmt.model.cm.jaxb.CaseMetadata;
import oracle.bpm.casemgmt.model.cm.jaxb.TCaseData;
import oracle.bpm.casemgmt.model.cm.jaxb.TCaseMetadata;
import oracle.bpm.casemgmt.model.cm.jaxb.TCategory;
import oracle.bpm.casemgmt.model.cm.jaxb.TData;
import oracle.bpm.casemgmt.model.cm.jaxb.TDataTypeEnum;
import oracle.bpm.casemgmt.model.cm.jaxb.TECMFolder;
import oracle.bpm.casemgmt.model.cm.jaxb.TMilestone;
import oracle.bpm.casemgmt.model.cm.jaxb.TMilestones;
import oracle.bpm.casemgmt.model.cm.jaxb.TNamespacePrefix;
import oracle.bpm.casemgmt.model.cm.jaxb.TNamespacePrefixes;
import oracle.bpm.casemgmt.model.cm.jaxb.TOutcome;
import oracle.bpm.casemgmt.model.cm.jaxb.TOutcomes;
import oracle.bpm.casemgmt.model.cm.jaxb.TPermissionMemberRole;
import oracle.bpm.casemgmt.model.cm.jaxb.TPermissionTag;
import oracle.bpm.casemgmt.model.cm.jaxb.TPermissionTags;
import oracle.bpm.casemgmt.model.cm.jaxb.TResourceBundle;
import oracle.bpm.casemgmt.model.cm.jaxb.TStakeHolder;
import oracle.bpm.casemgmt.model.cm.jaxb.TStakeHolders;
import oracle.bpm.casemgmt.model.cm.jaxb.TTranslatableValue;
import oracle.bpm.casemgmt.model.cm.jaxb.TUserDefinedEvent;
import oracle.bpm.casemgmt.model.cm.persistence.CaseTranslator;
import oracle.bpm.casemgmt.model.persistence.CommonWriter;
import oracle.bpm.lang.Str;

class CaseWriter
extends CommonWriter {
    static final CaseWriter INSTANCE = new CaseWriter();

    private CaseWriter() {
    }

    public CaseMetadata translate(Case casemgmt) {
        TCaseMetadata result = CaseTranslator.CASE_FACTORY.createTCaseMetadata();
        result.setTargetNamespace(casemgmt.getTargetNamespace());
        result.setName(casemgmt.getName());
        result.setId(casemgmt.getId());
        result.setTitle(this.translate(casemgmt.getTitle()));
        result.setPriority(BigInteger.valueOf(casemgmt.getPriority()));
        result.setCategory(this.translate(casemgmt.getCategory()));
        result.setPermissionTags(this.translate(casemgmt.getPermissions()));
        result.setMilestones(this.translate(casemgmt.getMilestones()));
        result.setEcmFolder(this.translate(casemgmt.getEcmFolder()));
        List<CaseData> caseDataList = casemgmt.getCaseData();
        List<TCaseData> tCaseDataList = result.getCaseData();
        for (CaseData caseData : caseDataList) {
            tCaseDataList.add(this.translate(caseData));
        }
        result.setEvents(this.translate(casemgmt.getEvents()));
        result.setOutcomes(this.translate(casemgmt.getOutcomes()));
        if (casemgmt.isPublishEvents()) {
            result.setPublishCaseEventsToEDN(casemgmt.isPublishEvents());
        }
        result.setStakeHolders(this.translate(casemgmt.getStakeHolders()));
        String bundle = casemgmt.getResourceBundle();
        if (bundle != null && !bundle.isEmpty()) {
            TResourceBundle tResourceBundle = CaseTranslator.CASE_FACTORY.createTResourceBundle();
            tResourceBundle.setName(bundle);
            result.setResourceBundle(tResourceBundle);
        }
        result.setNamespacePrefixes(this.translate(casemgmt.getNamespacePrefixes()));
        return CaseTranslator.CASE_FACTORY.createCaseMetadata(result);
    }

    private TCategory translate(Category category) {
        TTranslatableValue tTranslatableValue;
        TCategory result = null;
        if (category != null && category.getName() != null && (tTranslatableValue = this.translate(category.getName())) != null) {
            result = CaseTranslator.CASE_FACTORY.createTCategory();
            result.setName(tTranslatableValue);
        }
        return result;
    }

    private TPermissionTags translate(Permissions permissions) {
        TPermissionTags result = null;
        if (permissions != null && !permissions.isEmpty()) {
            result = CaseTranslator.CASE_FACTORY.createTPermissionTags();
            List<TPermissionTag> tPermissionTagList = result.getPermissionTag();
            for (String permission : permissions) {
                TPermissionTag tPermissionTag = CaseTranslator.CASE_FACTORY.createTPermissionTag();
                tPermissionTag.setCustomTagName(permission);
                tPermissionTagList.add(tPermissionTag);
            }
        }
        return result;
    }

    private TMilestones translate(Milestones milestones) {
        TMilestones result = null;
        if (milestones != null && !milestones.isEmpty()) {
            result = CaseTranslator.CASE_FACTORY.createTMilestones();
            List<TMilestone> tMilestoneList = result.getMilestone();
            for (Milestone milestone : milestones) {
                tMilestoneList.add(this.translate(milestone));
            }
        }
        return result;
    }

    private TMilestone translate(Milestone milestone) {
        TMilestone result = CaseTranslator.CASE_FACTORY.createTMilestone();
        result.setName(milestone.getName());
        result.setIsSoft(milestone.isRequired());
        return result;
    }

    private TECMFolder translate(EcmFolder ecmFolder) {
        TECMFolder result = null;
        if (ecmFolder != null) {
            result = CaseTranslator.CASE_FACTORY.createTECMFolder();
            result.setParentFolder(this.translate(ecmFolder.getParentFolder()));
            result.setCaseInstanceFolder(this.translate(ecmFolder.getCaseInstanceFolder()));
            result.setCreateSubFolderOnCaseInstanceCreation(ecmFolder.isCreateSubFolder());
        }
        return result;
    }

    private TCaseData translate(CaseData caseData) {
        TCaseData result = CaseTranslator.CASE_FACTORY.createTCaseData();
        List<TData> tDataList = result.getData();
        for (Data data : caseData) {
            tDataList.add(this.translate(data));
        }
        return result;
    }

    private TData translate(Data data) {
        TData result = CaseTranslator.CASE_FACTORY.createTData();
        result.setName(data.getName());
        result.setType(data.getType());
        result.setDataType(this.translate(data.getDataType()));
        result.setSchema(data.getSchema());
        result.setUpdatable(data.isEditable());
        return result;
    }

    private TDataTypeEnum translate(DataType type) {
        TDataTypeEnum result = null;
        if (type != null) {
            switch (type) {
                case SIMPLE_TYPE: {
                    result = TDataTypeEnum.SIMPLE_TYPE;
                    break;
                }
                case COMPLEX_TYPE: {
                    result = TDataTypeEnum.COMPLEX_TYPE;
                    break;
                }
                case ELEMENT: {
                    result = TDataTypeEnum.ELEMENT;
                }
            }
        }
        return result;
    }

    private TUserDefinedEvent translate(Events events) {
        TUserDefinedEvent result = null;
        if (events != null && !events.isEmpty()) {
            result = CaseTranslator.CASE_FACTORY.createTUserDefinedEvent();
            List<String> eventList = result.getUserDefinedEvent();
            eventList.addAll(events);
        }
        return result;
    }

    private TOutcomes translate(Outcomes outcomes) {
        TOutcomes result = null;
        if (outcomes != null && !outcomes.isEmpty()) {
            result = CaseTranslator.CASE_FACTORY.createTOutcomes();
            List<TOutcome> outcomeList = result.getOutcome();
            for (String outcome : outcomes) {
                TOutcome tOutcome = CaseTranslator.CASE_FACTORY.createTOutcome();
                tOutcome.setName(outcome);
                outcomeList.add(tOutcome);
            }
        }
        return result;
    }

    private TStakeHolders translate(StakeHolders stakeHolders) {
        TStakeHolders result = null;
        if (stakeHolders != null && !stakeHolders.isEmpty()) {
            result = CaseTranslator.CASE_FACTORY.createTStakeHolders();
            List<TStakeHolder> tStakeHolderList = result.getStakeHolder();
            for (StakeHolder stakeHolder : stakeHolders) {
                tStakeHolderList.add(this.translate(stakeHolder));
            }
        }
        return result;
    }

    private TStakeHolder translate(StakeHolder stakeHolder) {
        TStakeHolder result = CaseTranslator.CASE_FACTORY.createTStakeHolder();
        result.setName(stakeHolder.getName());
        result.setPermissionMemberRole(this.translate(stakeHolder.getPermissionRole()));
        for (Resource resource : stakeHolder) {
            result.getResource().add(this.translate(resource));
        }
        return result;
    }

    private TPermissionMemberRole translate(PermissionRole permissionRole) {
        TPermissionMemberRole result = null;
        if (permissionRole != null && !Str.isEmpty(permissionRole.getValue())) {
            result = CaseTranslator.CASE_FACTORY.createTPermissionMemberRole();
            result.setValue(permissionRole.getValue());
            result.setApplicationContext(permissionRole.getApplicationContext());
        }
        return result;
    }

    private TNamespacePrefixes translate(NamespacePrefixes namespacePrefixes) {
        TNamespacePrefixes result = null;
        if (namespacePrefixes != null && !namespacePrefixes.isEmpty()) {
            result = CaseTranslator.CASE_FACTORY.createTNamespacePrefixes();
            Set entries = namespacePrefixes.entrySet();
            for (Map.Entry entry : entries) {
                TNamespacePrefix tNamespacePrefix = CaseTranslator.CASE_FACTORY.createTNamespacePrefix();
                tNamespacePrefix.setPrefix((String)entry.getKey());
                tNamespacePrefix.setNamespace((String)entry.getValue());
                result.getNamespacePrefix().add(tNamespacePrefix);
            }
        }
        return result;
    }
}

