/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.model.cm.persistence;

import java.util.List;
import oracle.bpm.casemgmt.model.DataType;
import oracle.bpm.casemgmt.model.Value;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.CaseData;
import oracle.bpm.casemgmt.model.cm.CaseFactory;
import oracle.bpm.casemgmt.model.cm.Category;
import oracle.bpm.casemgmt.model.cm.Data;
import oracle.bpm.casemgmt.model.cm.EcmFolder;
import oracle.bpm.casemgmt.model.cm.Events;
import oracle.bpm.casemgmt.model.cm.Milestone;
import oracle.bpm.casemgmt.model.cm.Milestones;
import oracle.bpm.casemgmt.model.cm.NamespacePrefixes;
import oracle.bpm.casemgmt.model.cm.Outcomes;
import oracle.bpm.casemgmt.model.cm.PermissionRole;
import oracle.bpm.casemgmt.model.cm.Permissions;
import oracle.bpm.casemgmt.model.cm.StakeHolder;
import oracle.bpm.casemgmt.model.cm.StakeHolders;
import oracle.bpm.casemgmt.model.cm.jaxb.CaseMetadata;
import oracle.bpm.casemgmt.model.cm.jaxb.TCaseData;
import oracle.bpm.casemgmt.model.cm.jaxb.TCaseMetadata;
import oracle.bpm.casemgmt.model.cm.jaxb.TCategory;
import oracle.bpm.casemgmt.model.cm.jaxb.TData;
import oracle.bpm.casemgmt.model.cm.jaxb.TDataTypeEnum;
import oracle.bpm.casemgmt.model.cm.jaxb.TECMFolder;
import oracle.bpm.casemgmt.model.cm.jaxb.TMilestone;
import oracle.bpm.casemgmt.model.cm.jaxb.TMilestones;
import oracle.bpm.casemgmt.model.cm.jaxb.TNamespacePrefix;
import oracle.bpm.casemgmt.model.cm.jaxb.TNamespacePrefixes;
import oracle.bpm.casemgmt.model.cm.jaxb.TOutcome;
import oracle.bpm.casemgmt.model.cm.jaxb.TOutcomes;
import oracle.bpm.casemgmt.model.cm.jaxb.TPermissionMemberRole;
import oracle.bpm.casemgmt.model.cm.jaxb.TPermissionTag;
import oracle.bpm.casemgmt.model.cm.jaxb.TPermissionTags;
import oracle.bpm.casemgmt.model.cm.jaxb.TResource;
import oracle.bpm.casemgmt.model.cm.jaxb.TResourceBundle;
import oracle.bpm.casemgmt.model.cm.jaxb.TStakeHolder;
import oracle.bpm.casemgmt.model.cm.jaxb.TStakeHolders;
import oracle.bpm.casemgmt.model.cm.jaxb.TUserDefinedEvent;
import oracle.bpm.casemgmt.model.persistence.CommonLoader;

class CaseLoader
extends CommonLoader {
    static final CaseLoader INSTANCE = new CaseLoader();

    private CaseLoader() {
    }

    public Case translate(CaseMetadata caseMetadata) {
        TCaseMetadata tCaseMetadata = (TCaseMetadata)caseMetadata.getValue();
        Case result = CaseFactory.createCase(tCaseMetadata.getName());
        result.setTargetNamespace(tCaseMetadata.getTargetNamespace());
        result.setId(tCaseMetadata.getId());
        result.setTitle(this.translate(tCaseMetadata.getTitle()));
        result.setPriority(tCaseMetadata.getPriority().intValue());
        result.setCategory(this.translate(tCaseMetadata.getCategory()));
        result.setPermissions(this.translate(tCaseMetadata.getPermissionTags()));
        result.setMilestones(this.translate(tCaseMetadata.getMilestones()));
        result.setEcmFolder(this.translate(tCaseMetadata.getEcmFolder()));
        List<TCaseData> tCaseDataList = tCaseMetadata.getCaseData();
        for (TCaseData tCaseData : tCaseDataList) {
            result.addCaseData(this.translate(tCaseData));
        }
        result.setEvents(this.translate(tCaseMetadata.getEvents()));
        result.setOutcomes(this.translate(tCaseMetadata.getOutcomes()));
        if (tCaseMetadata.isSetPublishCaseEventsToEDN()) {
            result.setPublishEvents(tCaseMetadata.isPublishCaseEventsToEDN());
        }
        result.setStakeHolders(this.translate(tCaseMetadata.getStakeHolders()));
        TResourceBundle bundle = tCaseMetadata.getResourceBundle();
        if (bundle != null) {
            result.setResourceBundle(bundle.getName());
        }
        result.setNamespacePrefixes(this.translate(tCaseMetadata.getNamespacePrefixes()));
        return result;
    }

    private Category translate(TCategory tCategory) {
        Category result = CaseFactory.createCategory();
        if (tCategory != null) {
            result.setName(this.translate(tCategory.getName()));
        }
        return result;
    }

    private Permissions translate(TPermissionTags tPermissionTags) {
        Permissions result = CaseFactory.createPermissions();
        if (tPermissionTags != null) {
            List<TPermissionTag> tPermissionTagList = tPermissionTags.getPermissionTag();
            for (TPermissionTag tPermissionTag : tPermissionTagList) {
                if (!tPermissionTag.isSetCustomTagName()) continue;
                result.add(tPermissionTag.getCustomTagName());
            }
        }
        return result;
    }

    private Milestones translate(TMilestones tMilestones) {
        Milestones result = CaseFactory.createMilestones();
        if (tMilestones != null) {
            List<TMilestone> milestones = tMilestones.getMilestone();
            for (TMilestone tMilestone : milestones) {
                result.add(this.translate(tMilestone));
            }
        }
        return result;
    }

    private Milestone translate(TMilestone tMilestone) {
        Milestone result = CaseFactory.createMilestone();
        result.setName(tMilestone.getName());
        result.setRequired(tMilestone.isIsSoft());
        return result;
    }

    private EcmFolder translate(TECMFolder tEcmFolder) {
        EcmFolder result = CaseFactory.createEcmFolder();
        if (tEcmFolder != null) {
            Value instanceFolder;
            Value parentFolder = this.translate(tEcmFolder.getParentFolder());
            if (parentFolder != null) {
                result.setParentFolder(parentFolder);
            }
            if ((instanceFolder = this.translate(tEcmFolder.getCaseInstanceFolder())) != null) {
                result.setCaseInstanceFolder(instanceFolder);
            }
            result.setCreateSubFolder(tEcmFolder.isCreateSubFolderOnCaseInstanceCreation());
        }
        return result;
    }

    private CaseData translate(TCaseData tCaseData) {
        CaseData result = CaseFactory.createCaseData();
        List<TData> tDataList = tCaseData.getData();
        for (TData tData : tDataList) {
            result.add(this.translate(tData));
        }
        return result;
    }

    private Data translate(TData tData) {
        Data result = CaseFactory.createData();
        result.setName(tData.getName());
        result.setType(tData.getType());
        result.setDataType(this.translate(tData.getDataType()));
        result.setSchema(tData.getSchema());
        result.setEditable(tData.isUpdatable());
        return result;
    }

    private DataType translate(TDataTypeEnum type) {
        DataType result = null;
        if (type != null) {
            switch (type) {
                case SIMPLE_TYPE: {
                    result = DataType.SIMPLE_TYPE;
                    break;
                }
                case COMPLEX_TYPE: {
                    result = DataType.COMPLEX_TYPE;
                    break;
                }
                case ELEMENT: {
                    result = DataType.ELEMENT;
                }
            }
        }
        return result;
    }

    private Events translate(TUserDefinedEvent tUserDefinedEvent) {
        Events result = CaseFactory.createEvents();
        if (tUserDefinedEvent != null) {
            List<String> eventList = tUserDefinedEvent.getUserDefinedEvent();
            for (String event : eventList) {
                result.add(event);
            }
        }
        return result;
    }

    private Outcomes translate(TOutcomes tOutcomes) {
        Outcomes result = CaseFactory.createOutcomes();
        if (tOutcomes != null) {
            List<TOutcome> outcomeList = tOutcomes.getOutcome();
            for (TOutcome tOutcome : outcomeList) {
                result.add(tOutcome.getName());
            }
        }
        return result;
    }

    private StakeHolders translate(TStakeHolders tStakeHolders) {
        StakeHolders result = CaseFactory.createStakeHolders();
        if (tStakeHolders != null) {
            List<TStakeHolder> tStakeHolderList = tStakeHolders.getStakeHolder();
            for (TStakeHolder tStakeHolder : tStakeHolderList) {
                result.add(this.translate(tStakeHolder));
            }
        }
        return result;
    }

    private StakeHolder translate(TStakeHolder tStakeHolder) {
        StakeHolder result = CaseFactory.createStakeHolder();
        result.setName(tStakeHolder.getName());
        result.setPermissionRole(this.translate(tStakeHolder.getPermissionMemberRole()));
        List<TResource> tResources = tStakeHolder.getResource();
        for (TResource tResource : tResources) {
            result.add(this.translate(tResource));
        }
        return result;
    }

    private PermissionRole translate(TPermissionMemberRole tPermissionMemberRole) {
        PermissionRole result = CaseFactory.createPermissionRole();
        if (tPermissionMemberRole != null) {
            result.setValue(tPermissionMemberRole.getValue());
            result.setApplicationContext(tPermissionMemberRole.getApplicationContext());
        }
        return result;
    }

    private NamespacePrefixes translate(TNamespacePrefixes tNamespacePrefixes) {
        NamespacePrefixes result = CaseFactory.createNamespacePrefixes();
        if (tNamespacePrefixes != null) {
            List<TNamespacePrefix> tPrefixesList = tNamespacePrefixes.getNamespacePrefix();
            for (TNamespacePrefix tNamespacePrefix : tPrefixesList) {
                result.put(tNamespacePrefix.getPrefix(), tNamespacePrefix.getNamespace());
            }
        }
        return result;
    }
}

