/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.model.cm;

import oracle.bpm.casemgmt.model.CommonFactory;
import oracle.bpm.casemgmt.model.Translatable;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.CaseData;
import oracle.bpm.casemgmt.model.cm.Category;
import oracle.bpm.casemgmt.model.cm.Data;
import oracle.bpm.casemgmt.model.cm.EcmFolder;
import oracle.bpm.casemgmt.model.cm.Events;
import oracle.bpm.casemgmt.model.cm.Milestone;
import oracle.bpm.casemgmt.model.cm.Milestones;
import oracle.bpm.casemgmt.model.cm.NamespacePrefixes;
import oracle.bpm.casemgmt.model.cm.Outcomes;
import oracle.bpm.casemgmt.model.cm.PermissionRole;
import oracle.bpm.casemgmt.model.cm.Permissions;
import oracle.bpm.casemgmt.model.cm.StakeHolder;
import oracle.bpm.casemgmt.model.cm.StakeHolders;
import oracle.bpm.casemgmt.model.cm.impl.CaseDataImpl;
import oracle.bpm.casemgmt.model.cm.impl.CaseImpl;
import oracle.bpm.casemgmt.model.cm.impl.CategoryImpl;
import oracle.bpm.casemgmt.model.cm.impl.DataImpl;
import oracle.bpm.casemgmt.model.cm.impl.EcmFolderImpl;
import oracle.bpm.casemgmt.model.cm.impl.EventsImpl;
import oracle.bpm.casemgmt.model.cm.impl.MilestoneImpl;
import oracle.bpm.casemgmt.model.cm.impl.MilestonesImpl;
import oracle.bpm.casemgmt.model.cm.impl.NamespacePrefixesImpl;
import oracle.bpm.casemgmt.model.cm.impl.OutcomesImpl;
import oracle.bpm.casemgmt.model.cm.impl.PermissionRoleImpl;
import oracle.bpm.casemgmt.model.cm.impl.PermissionsImpl;
import oracle.bpm.casemgmt.model.cm.impl.StakeHolderImpl;
import oracle.bpm.casemgmt.model.cm.impl.StakeHoldersImpl;
import org.jetbrains.annotations.NotNull;

public class CaseFactory
extends CommonFactory {
    private CaseFactory() {
    }

    public static Case createCase(@NotNull String name) {
        return new CaseImpl(name);
    }

    public static Translatable createTitle() {
        return CaseFactory.createTranslatable();
    }

    public static Category createCategory() {
        return new CategoryImpl();
    }

    public static Permissions createPermissions() {
        return new PermissionsImpl();
    }

    public static Milestones createMilestones() {
        return new MilestonesImpl();
    }

    public static Milestone createMilestone() {
        return new MilestoneImpl();
    }

    public static EcmFolder createEcmFolder() {
        return new EcmFolderImpl();
    }

    public static CaseData createCaseData() {
        return new CaseDataImpl();
    }

    public static Data createData() {
        return new DataImpl();
    }

    public static Events createEvents() {
        return new EventsImpl();
    }

    public static Outcomes createOutcomes() {
        return new OutcomesImpl();
    }

    public static StakeHolders createStakeHolders() {
        return new StakeHoldersImpl();
    }

    public static StakeHolder createStakeHolder() {
        return new StakeHolderImpl();
    }

    public static PermissionRole createPermissionRole() {
        return new PermissionRoleImpl();
    }

    public static NamespacePrefixes createNamespacePrefixes() {
        return new NamespacePrefixesImpl();
    }
}

