/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.model;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventType;

public interface EventFilter {
    public static final EventType[] ACCEPT_ADDED_TYPE = new EventType[]{EventType.ATTR_ADDED};
    public static final EventType[] ACCEPT_CHANGED_TYPE = new EventType[]{EventType.ATTR_CHANGED};
    public static final EventType[] ACCEPT_REMOVED_TYPE = new EventType[]{EventType.ATTR_REMOVED};

    public Event[] apply(Event ... var1);

    public static abstract class Default
    implements EventFilter {
        @Override
        public Event[] apply(Event ... events) {
            List<Event> result = new ArrayList<Event>();
            for (Event event : events) {
                result = this.analyzedEvent(event, result);
            }
            return result.toArray(new Event[result.size()]);
        }

        protected Class<? extends Entity> validObject() {
            return null;
        }

        protected Entity validInstance() {
            return null;
        }

        protected EventType[] validEventTypes() {
            return EventType.values();
        }

        private List<Event> analyzedEvent(Event event, List<Event> validEvents) {
            Event childEvent;
            if (this.isValidEventType(event.getType()) && this.isValidObject(event.getObject()) && this.isValidInstance(event.getObject())) {
                validEvents.add(event);
            }
            if ((childEvent = event.getChildEvent()) != null) {
                this.analyzedEvent(childEvent, validEvents);
            }
            return validEvents;
        }

        private boolean isValidEventType(EventType eventType) {
            for (EventType type : this.validEventTypes()) {
                if (!type.equals((Object)eventType)) continue;
                return true;
            }
            return false;
        }

        private boolean isValidObject(Entity entity) {
            Class<? extends Entity> object = this.validObject();
            return object == null || object.isAssignableFrom(entity.getClass());
        }

        private boolean isValidInstance(Entity object) {
            Entity entity = this.validInstance();
            return entity == null || entity == object;
        }
    }
}

