/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.model;

import java.util.Locale;
import java.util.Set;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.PropertyBundles;
import oracle.bpm.casemgmt.model.Resource;
import oracle.bpm.casemgmt.model.Translatable;
import oracle.bpm.casemgmt.model.Value;
import oracle.bpm.casemgmt.model.impl.ParamsImpl;
import oracle.bpm.casemgmt.model.impl.PropertyBundleImpl;
import oracle.bpm.casemgmt.model.impl.PropertyBundlesImpl;
import oracle.bpm.casemgmt.model.impl.ResourceImpl;
import oracle.bpm.casemgmt.model.impl.TranslatableImpl;
import oracle.bpm.casemgmt.model.impl.ValueImpl;
import org.jetbrains.annotations.NotNull;

public class CommonFactory {
    protected CommonFactory() {
    }

    public static Translatable createTranslatable() {
        return new TranslatableImpl();
    }

    public static Translatable.Params createParams() {
        return new ParamsImpl();
    }

    public static Resource createResource() {
        return new ResourceImpl();
    }

    public static Value createValue() {
        return new ValueImpl();
    }

    public static PropertyBundles createPropertyBundles(String name) {
        return new PropertyBundlesImpl(name);
    }

    public static PropertyBundle createPropertyBundle(String nameWithLocale) {
        return new PropertyBundleImpl(nameWithLocale);
    }

    public static PropertyBundle createPropertyBundle(@NotNull Locale locale) {
        return new PropertyBundleImpl(locale);
    }

    public static PropertyBundle createDefaultPropertyBundle() {
        return new PropertyBundleImpl((Locale)null);
    }

    public static String getDefaultName(Set<String> names, String name) {
        String result = name;
        int i = 0;
        while (names.contains(result)) {
            result = name + i++;
        }
        return result;
    }
}

