/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.views;

import fuego.internal.test.FuegoTestInfo;
import fuego.jdev.test.TestStarter;
import fuego.jdev.test.tests.DefaultTestSuite;
import fuego.jdev.test.views.BaseView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Point;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.TableColorProvider;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.TreeSelectionMode;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseMotionAdapter;
import oracle.bpm.ui.event.MouseMotionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.tree.CheckTree;
import oracle.bpm.ui.tree.CheckTreeNode;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;
import oracle.ide.Ide;

public class JdevTestView
extends BaseView {
    private static JdevTestView instance;
    static final String VIEW_ID = "JdevTestWindow";

    private JdevTestView() {
        super(VIEW_ID);
    }

    public static JdevTestView getInstance() {
        if (instance == null) {
            instance = new JdevTestView();
        }
        return instance;
    }

    @Override
    public Msg getMsg() {
        return Msg.QUOTE("BPM Studio JDevTest");
    }

    @Override
    protected UiComponent createView(UiContainer parent) {
        TabbedPane tabbedPane = new TabbedPane(parent);
        TestsPanel testsPanel = new TestsPanel((UiContainer)tabbedPane);
        TestResultTableModel tableModel = testsPanel.getTestResult().getTableModel();
        tabbedPane.addTab("Run Tests", (UiComponent)testsPanel);
        tabbedPane.addTab("Test Result", (UiComponent)TestsResultPanel.create((UiContainer)tabbedPane, tableModel));
        tabbedPane.addTab("About", (UiComponent)AboutPanel.create((UiContainer)tabbedPane));
        return tabbedPane;
    }

    private class TestsPanel
    extends Panel {
        private TestResult testResult;

        public TestsPanel(UiContainer parent) {
            super(parent);
            this.init();
        }

        private void init() {
            Class[] testClasses;
            this.setLayout((Layout)new BorderLayout());
            final CheckTree checkTree = new CheckTree((UiContainer)this);
            checkTree.setSelectionMode(TreeSelectionMode.DISCONTIGUOUS_TREE_SELECTION);
            CheckTreeNode root = new CheckTreeNode(DefaultTestSuite.class);
            checkTree.setRoot((TreeNode)root);
            for (Class testClass : testClasses = DefaultTestSuite.ALL_TESTS) {
                CheckTreeNode child = new CheckTreeNode((Object)testClass);
                child.setTree((Tree)checkTree);
                root.add(child);
            }
            checkTree.setLabelProvider((LabelProvider)new LabelProvider.Default<TreeNode>(){

                public Image getIcon(TreeNode treeNode) {
                    return treeNode != null ? treeNode.getIcon() : null;
                }

                public String getText(TreeNode treeNode) {
                    String test = ((Class)treeNode.getUserObject()).getSimpleName();
                    String result = treeNode.isRoot() ? "All Tests (" + test + ")" : test;
                    return result;
                }
            });
            ToolBar toolBar = new ToolBar((UiContainer)this);
            final ComboBox appCombo = UiFactory.createComboBox((UiContainer)toolBar, (Object[])new String[]{"Use Current", "Create new one"});
            appCombo.setSelectedIndex(0);
            BaseAction runAction = new BaseAction(DesignerMsg.START_SIMULATION){

                public void actionPerformed(ActionEvent event) {
                    if (appCombo.getSelectedIndex() == 0) {
                        if (Ide.getActiveWorkspace() == null) {
                            MessageDialog.showError((UiContainer)TestsPanel.this.getOwnerWindow(), (Msg)Msg.QUOTE("There is no open Application"));
                            return;
                        }
                    } else {
                        MessageDialog.showNotice((Msg)Msg.QUOTE("I'm sorry, this option is still pending"));
                        return;
                    }
                    CheckTreeNode rootNode = checkTree.getRoot();
                    if (rootNode.isFullSelected()) {
                        TestsPanel.this.runAllTests();
                    } else {
                        ArrayList<Class> testsToRun = new ArrayList<Class>();
                        List children = rootNode.getChildren();
                        for (TreeNode treeNode : children) {
                            if (!((CheckTreeNode)treeNode).isFullSelected()) continue;
                            testsToRun.add((Class)treeNode.getUserObject());
                        }
                        TestsPanel.this.runTests(testsToRun);
                    }
                }
            };
            toolBar.add(runAction);
            toolBar.addSeparator();
            toolBar.add((UiComponent)Label.create((UiContainer)toolBar, (Msg)Msg.QUOTE("Application")));
            toolBar.add((UiComponent)appCombo);
            toolBar.add(Box.createHorizontalGlue((UiContainer)toolBar));
            this.add((UiComponent)toolBar, "North");
            this.add((UiComponent)checkTree, "Center");
        }

        private void addChildren(TreeNode treeNode) {
            Class clazz = (Class)treeNode.getUserObject();
            try {
                Object o = clazz.newInstance();
                if (o instanceof TestSuite) {
                    TestSuite suite = (TestSuite)o;
                    int n = suite.countTestCases();
                    for (int i = 0; i < n; ++i) {
                        Test test = suite.testAt(i);
                        CheckTreeNode child = new CheckTreeNode(test.getClass());
                        child.setTree(treeNode.getTree());
                        treeNode.add((TreeNode)child);
                        if (!(test instanceof TestSuite)) continue;
                        this.addChildren((TreeNode)child);
                    }
                }
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        private void runAllTests() {
            this.runTestSuite(new DefaultTestSuite());
        }

        private void runTests(Collection<Class> tests) {
            TestSuite testSuite = new TestSuite();
            for (Class aClass : tests) {
                testSuite.addTestSuite(aClass);
            }
            this.runTestSuite(testSuite);
        }

        private void runTestSuite(final TestSuite testSuite) {
            new Thread(){

                @Override
                public void run() {
                    TestResult result = TestsPanel.this.getTestResult();
                    result.clear();
                    testSuite.run((junit.framework.TestResult)result);
                }
            }.start();
        }

        private TestResult getTestResult() {
            if (this.testResult == null) {
                this.testResult = new TestResult();
            }
            return this.testResult;
        }
    }

    private static class TestsResultPanel
    extends Panel {
        public TestsResultPanel(UiContainer parent, TestResultTableModel tableModel) {
            super(parent);
            this.init(tableModel);
        }

        public static TestsResultPanel create(UiContainer parent, TestResultTableModel tableModel) {
            return new TestsResultPanel(parent, tableModel);
        }

        private void init(final TestResultTableModel tableModel) {
            this.setLayout((Layout)new BorderLayout());
            final Table table = new Table((UiContainer)this, (TableModel)tableModel);
            TableColorProvider.Default<Object> colorProvider = new TableColorProvider.Default<Object>(){

                public Color getForeground(Object element) {
                    FuegoTestInfo testInfo = (FuegoTestInfo)tableModel.getRow(this.getRow());
                    return testInfo.isOk() ? Color.GREEN : Color.RED;
                }
            };
            int count = tableModel.getColumnCount();
            for (int i = 0; i < count; ++i) {
                table.getColumn(i).setColorProvider((ColorProvider)colorProvider);
            }
            table.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent e) {
                    Point p = e.getPoint();
                    int row = table.rowAtPoint(p);
                    FuegoTestInfo fuegoTestInfo = (FuegoTestInfo)tableModel.getRow(row);
                    table.setToolTipText(fuegoTestInfo.failureMsg);
                }
            });
            this.add((UiComponent)table, "Center");
        }
    }

    private static class TestResult
    extends junit.framework.TestResult {
        TestResultTableModel tableModel;

        TestResult() {
            this.init();
        }

        public void clear() {
            this.tableModel.removeAllElements();
        }

        public TestResultTableModel getTableModel() {
            return this.tableModel;
        }

        private void init() {
            this.tableModel = new TestResultTableModel();
            TestStarter.Formatter formatter = new TestStarter.Formatter(){

                @Override
                protected void submitTest(FuegoTestInfo testInfo) {
                    TestResult.this.tableModel.addRow(testInfo);
                    if (!testInfo.isOk()) {
                        System.out.println("JdevTestView$TestResult.submitTest " + testInfo.toString() + "\n" + testInfo.failureMsg);
                    }
                }
            };
            this.addListener(formatter);
        }
    }

    private static class AboutPanel
    extends Panel {
        private static String MSG = "<html><center><font size=5>BPM Studio Jdev Test Framework</font><br><br>------------------------------------------------------------------------------<br>In order to run these tests automatically you must set two System Properties:<br>fuego.jdev.test.run=true<br>fuego.jdev.test.worspace=$HOME/tmp/studio-minimal/<WORKSPACE_DIR><br>[optional] fuego.jdev.test.closeide=true<br>------------------------------------------------------------------------------<br></center></html>";

        public AboutPanel(UiContainer parent) {
            super(parent);
            this.init();
        }

        public static AboutPanel create(UiContainer parent) {
            return new AboutPanel(parent);
        }

        private void init() {
            this.setLayout((Layout)new BorderLayout());
            this.add((UiComponent)Label.createWithNoColon((UiContainer)this, (Msg)Msg.QUOTE(MSG)), "Center");
        }
    }

    public static class TestResultTableModel
    extends ProviderTableModel<FuegoTestInfo> {
        private static final MsgList TITLES = MsgList.create(Msg.QUOTE("Test"), Msg.QUOTE("Duration"), Msg.QUOTE("Passed"));
        private static final int COLUMN_NAME = 0;
        private static final int COLUMN_DURATION = 1;
        private static final int COLUMN_STATUS = 2;

        TestResultTableModel() {
            super(TITLES);
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return super.getColumnClass(column);
        }

        public Object getValueAt(int row, int column) {
            FuegoTestInfo testInfo = (FuegoTestInfo)this.getRow(row);
            switch (column) {
                case 0: {
                    return testInfo.testName;
                }
                case 1: {
                    return String.valueOf(testInfo.duration);
                }
                case 2: {
                    return testInfo.isOk();
                }
            }
            return "";
        }
    }
}

