/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.toolkit;

import fuego.jdev.test.Assertions;
import fuego.jdev.test.TestStarter;
import fuego.jdev.test.UiRunnable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ProjectNavigatorTree;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.lang.Any;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.ui.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.NewWorkspaceCommand;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;

public class WorkbenchToolkit
extends Assertions {
    private static WorkbenchToolkit instance;

    private WorkbenchToolkit() {
    }

    public static WorkbenchToolkit getInstance() {
        if (instance == null) {
            instance = new WorkbenchToolkit();
        }
        return instance;
    }

    public StudioWorkbench getWorkbench() {
        return AbstractStudioWorkbench.getInstance();
    }

    public Object runInUi(final UiRunnable runnable) {
        final Any.Holder result = new Any.Holder();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        result.value = runnable.run();
                    }
                    catch (Throwable throwable) {
                        result.value = throwable;
                    }
                }
            });
        }
        catch (Throwable e) {
            result.value = e;
        }
        if (result.value instanceof Throwable) {
            if (result.value instanceof RuntimeException) {
                throw (RuntimeException)result.value;
            }
            if (result.value instanceof Error) {
                throw (Error)result.value;
            }
            throw new RuntimeException((Throwable)result.value);
        }
        return result.value;
    }

    public StudioEditor openEditorForObject(final Object input) {
        return (StudioEditor)this.runInUi(new UiRunnable(){

            @Override
            public Object run() {
                StudioWorkbench workbench = WorkbenchToolkit.this.getWorkbench();
                StudioEditor editor = workbench.openEditorForObject(input);
                if (editor == null) {
                    throw new AssertionError((Object)("Could not create editor for object '" + input + "'"));
                }
                if (!input.equals(editor.getInput())) {
                    throw new AssertionError((Object)("Wrong editor object '" + editor.getInput() + "'. It should be '" + input + "'"));
                }
                workbench.openEditor(editor);
                Assertions.assertFalse(editor.isDirty(), "Editor should not be dirty after open: " + editor);
                Assertions.assertNotNull(workbench.findEditorByObject(input), "Could not find editor for object '" + input + "'");
                return editor;
            }
        });
    }

    public StudioEditor findEditorByObject(final Object input) {
        return (StudioEditor)this.runInUi(new UiRunnable(){

            @Override
            public Object run() {
                StudioWorkbench workbench = WorkbenchToolkit.this.getWorkbench();
                return workbench.findEditorByObject(input);
            }
        });
    }

    public void assertClosedEditor(Object input) {
        StudioEditor editor = this.findEditorByObject(input);
        if (editor != null) {
            throw new AssertionError((Object)("Editor for '" + input + "' should be closed"));
        }
    }

    public void closeEditorByObject(final Object input) {
        this.runInUi(new UiRunnable(){

            @Override
            public Object run() {
                StudioWorkbench workbench = WorkbenchToolkit.this.getWorkbench();
                workbench.closeEditorForInput(input);
                WorkbenchToolkit.this.assertClosedEditor(input);
                return null;
            }
        });
    }

    public TreeNode findNodeInNavigator(final Object value) {
        return (TreeNode)this.runInUi(new UiRunnable(){

            @Override
            public Object run() {
                StudioWorkbench workbench = WorkbenchToolkit.this.getWorkbench();
                ProjectNavigatorTree tree = workbench.getProjectTree();
                LinkedList<TreeNode> pendingNodes = new LinkedList<TreeNode>();
                ProjectObjectTreeNode root = tree.getRoot();
                if (value instanceof ProjectObject) {
                    ProjectObject projectObject = (ProjectObject)value;
                    oracle.bpm.project.model.Project project = projectObject.getProject();
                    for (int i = 0; i < root.getChildCount(); ++i) {
                        TreeNode child = root.getChildAt(i);
                        if (child.getUserObject() != project) continue;
                        pendingNodes.add(child);
                        break;
                    }
                }
                if (pendingNodes.isEmpty()) {
                    pendingNodes.add((TreeNode)root);
                }
                return this.find(value, pendingNodes);
            }

            private TreeNode find(Object value2, LinkedList<TreeNode> pendingNodes) {
                TreeNode result = null;
                while (!pendingNodes.isEmpty()) {
                    TreeNode node = pendingNodes.removeFirst();
                    if (node.getUserObject() == value2) {
                        result = node;
                        break;
                    }
                    int count = node.getChildCount();
                    for (int i = 0; i < count; ++i) {
                        TreeNode child = node.getChildAt(i);
                        pendingNodes.add(child);
                    }
                }
                return result;
            }
        });
    }

    public TreeNode getNavigatorRoot() {
        return (TreeNode)this.runInUi(new UiRunnable(){

            @Override
            public Object run() {
                StudioWorkbench workbench = WorkbenchToolkit.this.getWorkbench();
                ProjectNavigatorTree tree = workbench.getProjectTree();
                return tree.getRoot();
            }
        });
    }

    public Workspace createWorkspace(String name) throws IOException, InstantiationException, IllegalAccessException {
        File workspaceFile = new File(TestStarter.BASE_WORKSPACE_DIR, name);
        URL url = workspaceFile.toURI().toURL();
        Context context = Context.newIdeContext();
        Workspace workspace = NewWorkspaceCommand.createEmptyWorkspace((Context)context, (URL)url);
        workspace.save();
        Ide.setActiveWorkspace((Workspace)workspace);
        return workspace;
    }

    public Workspace openOrCreateWorkspace(String name) throws IOException, IllegalAccessException, InstantiationException {
        Workspace workspace;
        File workspaceFile = new File(TestStarter.BASE_WORKSPACE_DIR, name);
        URL url = workspaceFile.toURI().toURL();
        Node node = NodeFactory.find((URL)url);
        if (node instanceof Workspace) {
            workspace = (Workspace)node;
            workspace.open();
            Ide.setActiveWorkspace((Workspace)workspace);
        } else {
            workspace = this.createWorkspace(name);
        }
        return workspace;
    }

    public void closeActiveWorkspace() throws IOException {
        Workspace workspace = Ide.getActiveWorkspace();
        WorkbenchToolkit.assertNotNull(workspace, "The Active Workspace doesn't exist. Impossible to close it.");
        workspace.close();
    }

    public void saveAll() throws Exception {
        Workspace activeWorkspace = Ide.getActiveWorkspace();
        if (activeWorkspace != null) {
            Context context = Context.newIdeContext((Node)activeWorkspace);
            CommandProcessor.createCommand((String)"oracle.ide.cmd.SaveAllCommand", (Context)context).doit();
        }
    }

    public Project openProject(URL projectUrl) throws Exception {
        URL projectURLInCanonicalForm = URLFileSystem.canonicalize((URL)projectUrl);
        Node projectNode = NodeFactory.findOrCreate((URL)projectURLInCanonicalForm);
        Project projectToBeOpened = null;
        if (projectNode instanceof Project) {
            projectToBeOpened = (Project)projectNode;
            WorkbenchToolkit.openProject(projectToBeOpened);
        }
        return projectToBeOpened;
    }

    private static void openProject(Project projectToBeOpened) throws Exception {
        Ide.getActiveWorkspace().add((Element)projectToBeOpened);
        UpdateMessage.fireChildAdded((Subject)Ide.getActiveWorkspace(), (Element)projectToBeOpened);
        Ide.setActiveProject((Project)projectToBeOpened);
        projectToBeOpened.open();
        UpdateMessage.fireObjectOpened((Subject)projectToBeOpened);
        FileOpenHistory.getInstance().updateProjectHistory(projectToBeOpened.getURL());
    }
}

