/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.toolkit;

import fuego.jdev.test.I18n;
import oracle.bpm.holidays.HolidayCalendar;
import oracle.bpm.lang.Interval;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;

public class ProjectObjects {
    private static int count = 1;

    public static ProjectObjectHandle<ProjectObject>[] createHandles(Project project) {
        return new ProjectObjectHandle[]{new ProcessHandle(project), new FolderContainerHandle(project), new OrganizationHandle(project), new RoleHandle(project), new OUHandle(project), new HolidayRuleHandle(project), new CalendarRuleHandle(project), new ModelSimulationHandle(project), new ProjectSimulationHandle(project), new BpmObjectHandle(project)};
    }

    private static class RoleHandle
    extends OrganizationalObjectHandle<Role> {
        public RoleHandle(Project project) {
            super(project, "Role");
        }

        @Override
        public Role create(String name) throws ProjectException {
            return this.getOrganization().createRole(name, name);
        }

        @Override
        public void updateData(Role object) {
            object.setDescription("New Description");
        }
    }

    private static class ProjectSimulationHandle
    extends ResourceProjectObjectHandleImpl<ProjectSimulation> {
        public ProjectSimulationHandle(Project project) {
            super(project, "ProjectSimulation");
        }

        @Override
        public ProjectSimulation create(String name) throws ProjectException {
            return this.getProject().getSimulations().createProjectSimulation(name);
        }

        @Override
        public void addToModel(ProjectSimulation object) throws ProjectException {
            this.getProject().getSimulations().addProjectSimulation(object);
        }

        @Override
        public void updateData(ProjectSimulation object) {
            object.setDuration(Interval.valueOf(10000L));
        }
    }

    private static class ProcessHandle
    extends ResourceProjectObjectHandleImpl<Process> {
        public ProcessHandle(Project project) {
            super(project, "Process");
        }

        @Override
        public Process create(String name) throws ProjectException {
            Process process = this.getProject().getModelsRoot().createModel(name);
            process.setDefaultLabel(name);
            return process;
        }

        @Override
        public void addToModel(Process object) throws ProjectException {
            this.getProject().getModelsRoot().addChild((ProjectObject)object);
        }

        @Override
        public void updateData(Process object) {
            object.setDefaultDescription("Default Description");
        }
    }

    private static class OUHandle
    extends OrganizationalObjectHandle<OrganizationalUnit> {
        public OUHandle(Project project) {
            super(project, "OU");
        }

        @Override
        public OrganizationalUnit create(String name) throws ProjectException {
            OrganizationalUnit root = this.getOrganization().getRootOrganizationalUnit();
            return this.getOrganization().createOrganizationalUnit(name, root);
        }

        @Override
        public void updateData(OrganizationalUnit object) {
            object.asMutable().setDescription("New Description");
        }
    }

    private static class OrganizationHandle
    extends ResourceProjectObjectHandleImpl<Organization> {
        public OrganizationHandle(Project project) {
            super(project, "Organization");
        }

        @Override
        public Organization create(String name) throws ProjectException {
            return this.getProject().getOrganization();
        }

        @Override
        public boolean isRemovable() {
            return false;
        }

        @Override
        public void updateData(Organization object) {
            try {
                Role role = object.createRole("Role", "Role");
                object.addOrganizationalObject((ProjectObject)role);
            }
            catch (ProjectException projectException) {
                // empty catch block
            }
        }
    }

    private static class ModelSimulationHandle
    extends ResourceProjectObjectHandleImpl<ModelSimulation> {
        public ModelSimulationHandle(Project project) {
            super(project, "ModelSimulation");
        }

        @Override
        public ModelSimulation create(String name) throws ProjectException {
            return this.getProject().getSimulations().createModelSimulation("MyProcess1", name);
        }

        @Override
        public void addToModel(ModelSimulation object) throws ProjectException {
            this.getProject().getSimulations().addModelSimulation("MyProcess1", object);
        }

        @Override
        public void updateData(ModelSimulation object) {
            object.setMaxInstances(5555);
        }
    }

    private static class HolidayRuleHandle
    extends OrganizationalObjectHandle<HolidayRule> {
        public HolidayRuleHandle(Project project) {
            super(project, "HolidayRule");
        }

        @Override
        public HolidayRule create(String name) throws ProjectException {
            return this.getOrganization().createHolidayRule(name);
        }

        @Override
        public void updateData(HolidayRule object) {
            object.asMutable().setHolidayCalendar(HolidayCalendar.valueOf("", ""));
        }
    }

    private static class FolderContainerHandle
    extends ResourceProjectObjectHandleImpl<FolderContainer> {
        public FolderContainerHandle(Project project) {
            super(project, "Folder");
        }

        @Override
        public FolderContainer create(String name) throws ProjectException {
            FolderContainer root = this.getProject().getModelsRoot();
            return root.createContainer(name);
        }

        @Override
        public void addToModel(FolderContainer object) throws ProjectException {
            this.getProject().getModelsRoot().addChild((ProjectObject)object);
        }

        @Override
        public boolean hasEditor() {
            return false;
        }

        @Override
        public boolean isUpdatable() {
            return false;
        }

        @Override
        public void updateData(FolderContainer object) {
        }
    }

    private static class CalendarRuleHandle
    extends OrganizationalObjectHandle<CalendarRule> {
        public CalendarRuleHandle(Project project) {
            super(project, "CalendarRule");
        }

        @Override
        public CalendarRule create(String name) throws ProjectException {
            return this.getOrganization().createCalendarRule(name);
        }

        @Override
        public void updateData(CalendarRule object) {
            object.asMutable().setTimeZone("GMT-2");
        }
    }

    private static class BpmObjectHandle
    extends ResourceProjectObjectHandleImpl<BpmObject> {
        public BpmObjectHandle(Project project) {
            super(project, "BpmObject");
        }

        @Override
        public BpmObject create(String name) throws ProjectException {
            CatalogModule rootModule = this.getProject().getCatalogRoot();
            CatalogModule catalogModule = rootModule.newModule(name + "Module");
            rootModule.addChild((ProjectObject)catalogModule);
            return catalogModule.newBpmObject(name);
        }

        @Override
        public void addToModel(BpmObject object) throws ProjectException {
            ((CatalogModule)object.getParentObject()).addChild((ProjectObject)object);
        }

        @Override
        public void updateData(BpmObject object) {
            try {
                CatalogMember member = object.createAttribute("attributeString", CatalogType.Default.getString());
                object.addChild((ProjectObject)member);
            }
            catch (ProjectException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static abstract class ResourceProjectObjectHandleImpl<T extends ProjectObject>
    extends ProjectObjectHandleImpl<T> {
        public ResourceProjectObjectHandleImpl(Project project, String prefix) {
            super(project, prefix);
        }

        @Override
        public boolean hasEditor() {
            return true;
        }

        @Override
        public boolean isAdaptableToUrl() {
            return true;
        }
    }

    private static abstract class ProjectObjectHandleImpl<T extends ProjectObject>
    implements ProjectObjectHandle<T> {
        private String prefix;
        private Project project;
        private static final String MY = I18n.msg("My");

        public ProjectObjectHandleImpl(Project project, String prefix) {
            this.project = project;
            this.prefix = prefix;
        }

        @Override
        public void addToModel(T object) throws ProjectException {
        }

        @Override
        public T create() throws ProjectException {
            return this.create(MY + this.prefix + count++);
        }

        @Override
        public void removeFromModel(T object) throws ProjectException {
            object.delete();
        }

        @Override
        public boolean hasEditor() {
            return false;
        }

        @Override
        public boolean isUpdatable() {
            return true;
        }

        @Override
        public boolean isAddable() {
            return true;
        }

        @Override
        public boolean isRemovable() {
            return true;
        }

        @Override
        public boolean isAdaptableToUrl() {
            return false;
        }

        public String toString() {
            String simpleName = this.getClass().getSimpleName();
            simpleName = simpleName.substring(0, simpleName.length() - "Handle".length());
            return simpleName.toLowerCase();
        }

        protected Project getProject() {
            return this.project;
        }
    }

    private static abstract class OrganizationalObjectHandle<T extends ProjectObject>
    extends ProjectObjectHandleImpl<T> {
        public OrganizationalObjectHandle(Project project, String prefix) {
            super(project, prefix);
        }

        @Override
        public void addToModel(T object) throws ProjectException {
            this.getProject().getOrganization().addOrganizationalObject(object);
        }

        protected Organization getOrganization() {
            return this.getProject().getOrganization();
        }
    }

    public static interface ProjectObjectHandle<T extends ProjectObject> {
        public T create() throws ProjectException;

        public T create(String var1) throws ProjectException;

        public void updateData(T var1);

        public void addToModel(T var1) throws ProjectException;

        public void removeFromModel(T var1) throws ProjectException;

        public boolean hasEditor();

        public boolean isUpdatable();

        public boolean isAddable();

        public boolean isRemovable();

        public boolean isAdaptableToUrl();
    }
}

