/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.toolkit;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.exception.ProjectException;

public class MyProjectListener
extends ProjectListenerAdapter<ProjectObject> {
    private List<ProjectObject> changed = new ArrayList<ProjectObject>();
    private List<ProjectObject> postAdded = new ArrayList<ProjectObject>();
    private List<ProjectObject> postRemoved = new ArrayList<ProjectObject>();
    private List<ProjectObject> preAdded = new ArrayList<ProjectObject>();
    private List<ProjectObject> preRemoved = new ArrayList<ProjectObject>();
    private List<ProjectObject> replaced = new ArrayList<ProjectObject>();

    public MyProjectListener(List<ProjectObjectType> types) {
        super(ProjectObject.class);
    }

    public Class<ProjectObject> getSupportedTypes() {
        return ProjectObject.class;
    }

    public void objectChanged(ProjectObject projectObject, ProjectEvent event) {
        this.changed.add(projectObject);
    }

    public void objectReplaced(ProjectObject oldObject, ProjectObject newObject) {
        this.replaced.add(oldObject);
    }

    public void postObjectAdded(ProjectObject object, ProjectObject parent) {
        assert (this.preAdded.contains(object)) : "PostAdded event without PreAdded event: " + object;
        this.postAdded.add(object);
    }

    public void postObjectRemoved(ProjectObject object, ProjectObject parent) {
        assert (this.preRemoved.contains(object)) : "PostRemoved event without PreRemoved event: " + object;
        this.postRemoved.add(object);
    }

    public void preObjectAdded(ProjectObject object, ProjectObject parent) throws ProjectException {
        this.preAdded.add(object);
    }

    public void preObjectRemoved(ProjectObject object, ProjectObject parent) throws ProjectException {
        this.preRemoved.add(object);
    }

    public List<ProjectObject> getChanged() {
        return this.changed;
    }

    public List<ProjectObject> getReplaced() {
        return this.replaced;
    }

    public List<ProjectObject> getPostAdded() {
        return this.postAdded;
    }

    public List<ProjectObject> getPostRemoved() {
        return this.postRemoved;
    }

    public List<ProjectObject> getPreAdded() {
        return this.preAdded;
    }

    public List<ProjectObject> getPreRemoved() {
        return this.preRemoved;
    }

    public void clear() {
        this.changed.clear();
        this.replaced.clear();
        this.postAdded.clear();
        this.postRemoved.clear();
        this.preAdded.clear();
        this.preRemoved.clear();
    }

    public int getEventCount() {
        return this.changed.size() + this.replaced.size() + this.postAdded.size() + this.postRemoved.size() + this.preAdded.size() + this.preRemoved.size();
    }

    public boolean isEmpty() {
        return this.getEventCount() == 0;
    }
}

