/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.tests.project;

import fuego.jdev.test.tests.BaseProjectTest;
import fuego.jdev.test.toolkit.MyProjectListener;
import fuego.jdev.test.toolkit.ProjectObjects;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.exception.ProjectException;

public class ProjectObjectListenerTest
extends BaseProjectTest {
    private ProjectObjects.ProjectObjectHandle<ProjectObject> handle;

    public ProjectObjectListenerTest(Project project, ProjectObjects.ProjectObjectHandle<ProjectObject> handle) {
        super("projectObjectListener-" + handle);
        this.handle = handle;
    }

    protected void runTest() throws Throwable {
        this.testEvents(false);
        this.testEvents(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEvents(boolean useAllTypes) throws ProjectException {
        ProjectObject object = this.handle.create();
        ProjectObjectType type = useAllTypes ? ProjectObjectType.ALL : object.getProjectObjectType();
        MyProjectListener listener = new MyProjectListener(type.asList());
        Project project = this.getProject();
        try {
            project.addListener((ProjectListener)listener);
            ProjectObjectListenerTest.assertTrue((boolean)listener.isEmpty());
            if (this.handle.isAddable()) {
                this.handle.addToModel(object);
                ProjectObjectListenerTest.assertTrue((String)("Missing PreAdded event for " + object), (boolean)listener.getPreAdded().contains(object));
                ProjectObjectListenerTest.assertTrue((String)("Missing PostAdded event for " + object), (boolean)listener.getPostAdded().contains(object));
            }
            if (this.handle.isUpdatable()) {
                this.handle.updateData(object);
                ProjectObjectListenerTest.assertTrue((String)("Missing Change event for " + object), (boolean)listener.getChanged().contains(object));
            }
            this.handle.removeFromModel(object);
            if (this.handle.isRemovable()) {
                ProjectObjectListenerTest.assertTrue((String)("Missing PreRemoved event for " + object), (boolean)listener.getPreRemoved().contains(object));
                ProjectObjectListenerTest.assertTrue((String)("Missing PostRemoved event for " + object), (boolean)listener.getPostRemoved().contains(object));
            }
        }
        finally {
            project.removeListener((ProjectListener)listener);
        }
    }
}

