/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.tests.process;

import fuego.jdev.test.I18n;
import fuego.jdev.test.tests.process.BaseProcessTest;
import oracle.bpm.command.Command;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.design.AddActivityCommand;
import oracle.bpm.project.command.design.AddTransitionCommand;
import oracle.bpm.project.command.design.ChangeActivityTypeCommand;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.StartEvent;

public class ProcessTest
extends BaseProcessTest {
    private static final String PROCESS_NAME = I18n.msg("ProcessTest");
    private static final BaseProcessTest.ActivityTemplate ABSTRACT_ACTIVITY = BaseProcessTest.ActivityTemplate.create(I18n.msg("Activity"), BpmnType.ABSTRACT_ACTIVITY);
    private static final BaseProcessTest.ActivityTemplate SERVICE_TASK_NAME = BaseProcessTest.ActivityTemplate.create(I18n.msg("Service Task"), BpmnType.SERVICE_TASK);
    private static final BaseProcessTest.ActivityTemplate RECEIVE_TASK_NAME = BaseProcessTest.ActivityTemplate.create(I18n.msg("Receive Task"), BpmnType.RECEIVE_TASK);
    private static final BaseProcessTest.ActivityTemplate BUSINESS_RULE_TASK_NAME = BaseProcessTest.ActivityTemplate.create(I18n.msg("Business Rule"), BpmnType.BUSINESS_RULE_TASK);
    private static final BaseProcessTest.ActivityTemplate MANUAL_TASK_NAME = BaseProcessTest.ActivityTemplate.create(I18n.msg("Manual"), BpmnType.MANUAL_TASK);
    private static final BaseProcessTest.ActivityTemplate USER_TASK_NAME = BaseProcessTest.ActivityTemplate.create(I18n.msg("User"), BpmnType.USER_TASK);
    private static final BaseProcessTest.ActivityTemplate[] ACTIVITIES = new BaseProcessTest.ActivityTemplate[]{ABSTRACT_ACTIVITY, SERVICE_TASK_NAME, RECEIVE_TASK_NAME, BUSINESS_RULE_TASK_NAME};
    private static final BaseProcessTest.ActivityTemplate[] INTERACTIVE_ACTIVITIES = new BaseProcessTest.ActivityTemplate[]{MANUAL_TASK_NAME, USER_TASK_NAME};

    public void testNewActivity() throws ProjectException {
        Process process = this.createProcess(PROCESS_NAME);
        this.workbench().openEditorForObject(process);
        ProcessTest.run((Command)((Object)BaseProcessTest.RemoveStarEndSequenceFlowCommand.create(process)));
        StartEvent previous = ProcessTest.getStartEvent(process);
        for (BaseProcessTest.ActivityTemplate template : ACTIVITIES) {
            Activity activity = process.createActivity();
            activity.setDefaultLabel(template.getTaskName());
            ChangeActivityTypeCommand.change((Activity)activity, (BpmnType)template.getType());
            ProcessTest.run((Command)new AddActivityCommand((FlowNode)activity, new Point(0, 0)));
            ProcessTest.run((Command)new AddTransitionCommand((NodeContainer)process, (FlowNode)previous, (FlowNode)activity));
            ProcessTest.runLayout(process);
            previous = activity;
        }
        EndEvent endEvent = ProcessTest.getEndEvent(process);
        ProcessTest.run((Command)new AddTransitionCommand((NodeContainer)process, (FlowNode)previous, (FlowNode)endEvent));
        ProcessTest.runLayout(process);
        ProcessTest.assertEquals((String)"Activities in Process.", (int)ACTIVITIES.length, (int)process.getActivities().toArray().length);
        ProcessTest.assertEquals((String)"Events in Process.", (int)2, (int)process.getEvents().toArray().length);
        ProcessTest.assertEquals((String)"Sequence Flows in Process.", (int)(ACTIVITIES.length + 1), (int)process.getSequenceFlows().toArray().length);
        ProcessTest.assertTrue((String)("Process Node should be dirty after changes: " + process), (boolean)ProcessTest.isResourceObjectDirty((ResourceObject)process));
    }
}

