/*
 * Decompiled with CFR 0.152.
 */
package fuego.jdev.test.tests.process;

import fuego.jdev.test.tests.BaseProjectTest;
import junit.framework.Assert;
import oracle.bpm.collections.Sequence;
import oracle.bpm.command.Command;
import oracle.bpm.designer.command.RemoveObjectsCommand;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.design.LayoutModelCommand;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.ui.ModelObjectSelection;

public abstract class BaseProcessTest
extends BaseProjectTest {
    public static void removeFlowElement(FlowElement flowElement) {
        BaseProcessTest.run((Command)new RemoveObjectsCommand(ModelObjectSelection.create((FlowElement[])new FlowElement[]{flowElement})));
    }

    protected static EndEvent getEndEvent(Process process) {
        Sequence events = process.getEvents(EndEvent.class);
        for (EndEvent event : events) {
            if (!event.isEnd()) continue;
            return event;
        }
        return null;
    }

    protected static StartEvent getStartEvent(Process process) {
        Sequence events = process.getEvents(StartEvent.class);
        for (StartEvent event : events) {
            if (!event.isStart()) continue;
            return event;
        }
        return null;
    }

    protected static SequenceFlow getStartEndSequenceFlow(Process process) {
        Sequence sequenceFlows = process.getSequenceFlows();
        return (SequenceFlow)sequenceFlows.iterator().next();
    }

    protected static void runLayout(Process process) {
        BaseProcessTest.run((Command)new LayoutModelCommand(process, false, false));
    }

    protected Process createProcess(String name) throws ProjectException {
        Project project = this.getProject();
        Process process = project.getModelsRoot().createModel(name);
        BaseProcessTest.run((Command)((Object)AddProcessCommand.create(project.getModelsRoot(), process)));
        return process;
    }

    protected static class RemoveStarEndSequenceFlowCommand
    extends ProjectCommand {
        private Process process;

        public RemoveStarEndSequenceFlowCommand(Process process) {
            super(new ProjectObject[0]);
            this.process = process;
        }

        public static RemoveStarEndSequenceFlowCommand create(Process process) {
            return new RemoveStarEndSequenceFlowCommand(process);
        }

        public String getName() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }

        public Object execute() throws ExecutionException {
            StartEvent startEvent = BaseProcessTest.getStartEvent(this.process);
            Assert.assertNotNull((String)"Activity startEvent should exist in process", (Object)startEvent);
            EndEvent endEvent = BaseProcessTest.getEndEvent(this.process);
            Assert.assertNotNull((String)"Activity endEvent should exist in process", (Object)endEvent);
            SequenceFlow startEndSequenceFlow = BaseProcessTest.getStartEndSequenceFlow(this.process);
            if (startEndSequenceFlow != null) {
                BaseProcessTest.removeFlowElement((FlowElement)startEndSequenceFlow);
            }
            return null;
        }
    }

    protected static class AddProcessCommand
    extends ProjectCommand {
        private FolderContainer container;
        private Process process;

        public AddProcessCommand(FolderContainer container, Process process) {
            super(new ProjectObject[0]);
            this.container = container;
            this.process = process;
        }

        public static AddProcessCommand create(FolderContainer container, Process process) {
            return new AddProcessCommand(container, process);
        }

        public String getName() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }

        public Object execute() throws ExecutionException {
            try {
                this.container.addChild((ProjectObject)this.process);
            }
            catch (ProjectException e) {
                throw new ExecutionException(e);
            }
            return null;
        }
    }

    public static class ActivityTemplate {
        private String taskName;
        private BpmnType type;

        protected ActivityTemplate(String taskName, BpmnType type) {
            this.taskName = taskName;
            this.type = type;
        }

        public static ActivityTemplate create(String name, BpmnType type) {
            return new ActivityTemplate(name, type);
        }

        public String getTaskName() {
            return this.taskName;
        }

        public BpmnType getType() {
            return this.type;
        }
    }
}

